/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr.formats;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.server.rest.repr.BadInputException;
import org.neo4j.server.rest.repr.DefaultFormat;
import org.neo4j.server.rest.repr.ListWriter;
import org.neo4j.server.rest.repr.MappingWriter;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.formats.ListWrappingWriter;
import org.neo4j.server.rest.repr.formats.MapWrappingWriter;

public class JsonFormat
extends RepresentationFormat {
    public JsonFormat() {
        super(MediaType.APPLICATION_JSON_TYPE);
    }

    protected ListWriter serializeList(String type) {
        return new ListWrappingWriter(new ArrayList<Object>());
    }

    protected String complete(ListWriter serializer) {
        return JsonHelper.createJsonFrom(((ListWrappingWriter)serializer).data);
    }

    protected MappingWriter serializeMapping(String type) {
        return new MapWrappingWriter(new HashMap<String, Object>());
    }

    protected String complete(MappingWriter serializer) {
        return JsonHelper.createJsonFrom(((MapWrappingWriter)serializer).data);
    }

    protected String serializeValue(String type, Object value) {
        return JsonHelper.createJsonFrom(value);
    }

    private boolean empty(String input) {
        return input == null || "".equals(input.trim());
    }

    public Map<String, Object> readMap(String input, String ... requiredKeys) throws BadInputException {
        if (this.empty(input)) {
            return DefaultFormat.validateKeys(Collections.emptyMap(), requiredKeys);
        }
        try {
            return DefaultFormat.validateKeys(JsonHelper.jsonToMap(this.stripByteOrderMark(input)), requiredKeys);
        }
        catch (JsonParseException ex) {
            throw new BadInputException((Throwable)((Object)ex));
        }
    }

    public List<Object> readList(String input) throws BadInputException {
        try {
            return (List)JsonHelper.readJson(input);
        }
        catch (ClassCastException ex) {
            throw new BadInputException((Throwable)ex);
        }
        catch (JsonParseException ex) {
            throw new BadInputException((Throwable)((Object)ex));
        }
    }

    public Object readValue(String input) throws BadInputException {
        if (this.empty(input)) {
            return Collections.emptyMap();
        }
        try {
            return JsonHelper.jsonToSingleValue(this.stripByteOrderMark(input));
        }
        catch (JsonParseException ex) {
            throw new BadInputException((Throwable)((Object)ex));
        }
    }

    public URI readUri(String input) throws BadInputException {
        try {
            return new URI(this.readValue(input).toString());
        }
        catch (URISyntaxException e) {
            throw new BadInputException((Throwable)e);
        }
    }

    private String stripByteOrderMark(String string) {
        if (string != null && string.length() > 0 && string.charAt(0) == '\ufeff') {
            return string.substring(1);
        }
        return string;
    }
}

