/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.ObjectMapper;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.server.database.Database;
import org.neo4j.server.rest.domain.BatchOperationFailedException;
import org.neo4j.server.rest.repr.BadInputException;
import org.neo4j.server.rest.repr.BatchOperationResults;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.web.InternalJettyServletRequest;
import org.neo4j.server.rest.web.InternalJettyServletResponse;
import org.neo4j.server.web.WebServer;

@Path(value="/batch")
public class BatchOperationService {
    private static final String ID_KEY = "id";
    private static final String METHOD_KEY = "method";
    private static final String BODY_KEY = "body";
    private static final String TO_KEY = "to";
    private static final JsonFactory jsonFactory = new JsonFactory();
    private final OutputFormat output;
    private final WebServer webServer;
    private final Database database;

    public BatchOperationService(@Context Database database, @Context WebServer webServer, @Context OutputFormat output) {
        this.output = output;
        this.webServer = webServer;
        this.database = database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    public Response performBatchOperations(@Context UriInfo uriInfo, @Context HttpHeaders httpHeaders, InputStream body) throws BadInputException {
        GraphDatabaseAPI db = this.database.graph;
        Transaction tx = db.beginTx();
        try {
            JsonToken token;
            JsonParser jp = jsonFactory.createJsonParser(body);
            ObjectMapper mapper = new ObjectMapper();
            BatchOperationResults results = new BatchOperationResults();
            while ((token = jp.nextToken()) != null) {
                if (token != JsonToken.START_OBJECT) continue;
                String jobBody = "";
                String jobPath = "";
                String jobMethod = "";
                Integer jobId = null;
                while ((token = jp.nextToken()) != JsonToken.END_OBJECT && token != null) {
                    String field = jp.getText();
                    token = jp.nextToken();
                    if (field.equals(METHOD_KEY)) {
                        jobMethod = jp.getText().toUpperCase();
                        continue;
                    }
                    if (field.equals(TO_KEY)) {
                        jobPath = jp.getText();
                        continue;
                    }
                    if (field.equals(ID_KEY)) {
                        jobId = jp.getIntValue();
                        continue;
                    }
                    if (!field.equals(BODY_KEY)) continue;
                    JsonNode node = mapper.readTree(jp);
                    StringWriter out = new StringWriter();
                    JsonGenerator gen = jsonFactory.createJsonGenerator((Writer)out);
                    mapper.writeTree(gen, node);
                    gen.flush();
                    gen.close();
                    jobBody = out.toString();
                }
                this.performJob(results, uriInfo, jobMethod, jobPath, jobBody, jobId, httpHeaders);
            }
            Response res = Response.ok().entity((Object)results.toJSON()).header("Content-Encoding", (Object)"UTF-8").type("application/json").build();
            tx.success();
            Response response = res;
            return response;
        }
        catch (Exception e) {
            tx.failure();
            Response response = this.output.serverError(e);
            return response;
        }
        finally {
            tx.finish();
        }
    }

    private void performJob(BatchOperationResults results, UriInfo uriInfo, String method, String path, String body, Integer id, HttpHeaders httpHeaders) throws IOException, ServletException {
        Map<Integer, String> locations = results.getLocations();
        path = this.replaceLocationPlaceholders(path, locations);
        body = this.replaceLocationPlaceholders(body, locations);
        URI targetUri = this.calculateTargetUri(uriInfo, path);
        InternalJettyServletRequest req = new InternalJettyServletRequest(method, targetUri.toString(), body);
        InternalJettyServletResponse res = new InternalJettyServletResponse();
        this.addHeaders(req, httpHeaders);
        this.webServer.invokeDirectly(targetUri.getPath(), (HttpServletRequest)req, (HttpServletResponse)res);
        if (!this.is2XXStatusCode(res.getStatus())) {
            throw new BatchOperationFailedException(res.getStatus(), res.getOutputStream().toString());
        }
        results.addOperationResult(path, id, res.getOutputStream().toString(), res.getHeader("Location"));
    }

    private void addHeaders(InternalJettyServletRequest res, HttpHeaders httpHeaders) {
        for (Map.Entry header : httpHeaders.getRequestHeaders().entrySet()) {
            String key = (String)header.getKey();
            List value = (List)header.getValue();
            if (value == null) continue;
            if (value.size() != 1) {
                throw new IllegalArgumentException("expecting one value per header");
            }
            if (key.equals("Accept") || key.equals("Content-Type")) continue;
            res.addHeader(key, (String)value.get(0));
        }
        res.addHeader("Accept", "application/json");
        res.addHeader("Content-Type", "application/json");
    }

    private URI calculateTargetUri(UriInfo serverUriInfo, String requestedPath) {
        URI baseUri = serverUriInfo.getBaseUri();
        if (requestedPath.startsWith(baseUri.toString())) {
            requestedPath = requestedPath.substring(baseUri.toString().length());
        }
        if (!requestedPath.startsWith("/")) {
            requestedPath = "/" + requestedPath;
        }
        return baseUri.resolve("." + requestedPath);
    }

    private String replaceLocationPlaceholders(String str, Map<Integer, String> locations) {
        for (Integer jobId : locations.keySet()) {
            str = str.replace("{" + jobId + "}", locations.get(jobId));
        }
        return str;
    }

    private boolean is2XXStatusCode(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }
}

