/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.startup.healthcheck;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.neo4j.server.startup.healthcheck.StartupHealthCheckRule;

public class Neo4jPropertiesMustExistRule
implements StartupHealthCheckRule {
    private static final String EMPTY_STRING = "";
    private boolean passed = false;
    private boolean ran = false;
    protected String failureMessage = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(Properties properties) {
        this.ran = true;
        String configFilename = properties.getProperty("org.neo4j.server.properties");
        Properties configProperties = new Properties();
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(configFilename);
            configProperties.load(inputStream);
        }
        catch (IOException e) {
            this.failureMessage = String.format("Failed to load configuration properties from [%s]", configFilename);
            boolean bl = false;
            return bl;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
        this.passed = this.validateProperties(configProperties);
        return this.passed;
    }

    protected boolean validateProperties(Properties configProperties) {
        return true;
    }

    @Override
    public String getFailureMessage() {
        if (this.passed) {
            return EMPTY_STRING;
        }
        if (!this.ran) {
            return String.format("%s has not been run", this.getClass().getName());
        }
        return this.failureMessage;
    }
}

