/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web;

import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.spi.container.WebApplication;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import com.sun.jersey.spi.container.servlet.WebConfig;
import java.util.Collection;
import java.util.Set;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.server.NeoServer;
import org.neo4j.server.NeoServerProvider;
import org.neo4j.server.NeoServerWithEmbeddedWebServer;
import org.neo4j.server.configuration.ConfigurationProvider;
import org.neo4j.server.database.AbstractInjectableProvider;
import org.neo4j.server.database.DatabaseProvider;
import org.neo4j.server.database.GraphDatabaseServiceProvider;
import org.neo4j.server.plugins.Injectable;
import org.neo4j.server.plugins.PluginInvocatorProvider;
import org.neo4j.server.rest.paging.LeaseManagerProvider;
import org.neo4j.server.rest.repr.InputFormatProvider;
import org.neo4j.server.rest.repr.OutputFormatProvider;
import org.neo4j.server.rest.repr.RepresentationFormatRepository;
import org.neo4j.server.rrd.RrdDbProvider;
import org.neo4j.server.web.WebServerProvider;

public class NeoServletContainer
extends ServletContainer {
    private final NeoServer server;
    private final Collection<Injectable<?>> injectables;

    public NeoServletContainer(NeoServer server, Collection<Injectable<?>> injectables) {
        this.server = server;
        this.injectables = injectables;
    }

    protected void configure(WebConfig wc, ResourceConfig rc, WebApplication wa) {
        super.configure(wc, rc, wa);
        Set singletons = rc.getSingletons();
        singletons.add(new LeaseManagerProvider());
        singletons.add(new DatabaseProvider(this.server.getDatabase()));
        singletons.add(new GraphDatabaseServiceProvider((GraphDatabaseService)this.server.getDatabase().graph));
        singletons.add(new NeoServerProvider(this.server));
        singletons.add(new ConfigurationProvider(this.server.getConfiguration()));
        if (this.server.getDatabase().rrdDb() != null) {
            singletons.add(new RrdDbProvider(this.server.getDatabase().rrdDb()));
        }
        if (this.server instanceof NeoServerWithEmbeddedWebServer) {
            singletons.add(new WebServerProvider(((NeoServerWithEmbeddedWebServer)this.server).getWebServer()));
        }
        RepresentationFormatRepository repository = new RepresentationFormatRepository(this.server.getExtensionManager());
        singletons.add(new InputFormatProvider(repository));
        singletons.add(new OutputFormatProvider(repository));
        singletons.add(new PluginInvocatorProvider(this.server.getExtensionManager()));
        for (Injectable<?> injectable : this.injectables) {
            singletons.add(new InjectableWrapper(injectable));
        }
    }

    private static class InjectableWrapper
    extends AbstractInjectableProvider<Object> {
        private final Injectable injectable;

        public InjectableWrapper(Injectable injectable) {
            super(injectable.getType());
            this.injectable = injectable;
        }

        public Object getValue(HttpContext c) {
            return this.injectable.getValue();
        }
    }
}

