(function() {
  /*
  Copyright (c) 2002-2012 "Neo Technology,"
  Network Engine for Objects in Lund AB [http://neotechnology.com]
  
  This file is part of Neo4j.
  
  Neo4j is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  */
  var __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };
  define(['./connection_lost', 'lib/amd/jQuery'], function(template, $) {
    var CONNECTION_LOST_EVENT, ConnectionMonitor;
    CONNECTION_LOST_EVENT = "web.connection_lost";
    return ConnectionMonitor = (function() {
      function ConnectionMonitor() {
        this.connectionLost = __bind(this.connectionLost, this);
      }
      ConnectionMonitor.prototype.visible = false;
      ConnectionMonitor.prototype.init = function(appState) {
        this.db = appState.getServer();
        this.db.bind(CONNECTION_LOST_EVENT, this.connectionLost);
        return this.db.heartbeat.addListener(function() {});
      };
      ConnectionMonitor.prototype.connectionLost = function() {
        var connectionLostSplash, hideSplash;
        if (!this.visible) {
          this.visible = true;
          connectionLostSplash = $(template());
          $("body").append(connectionLostSplash);
          hideSplash = __bind(function() {
            this.visible = false;
            return connectionLostSplash.fadeOut(200, function() {
              return connectionLostSplash.remove();
            });
          }, this);
          return this.db.heartbeat.waitForPulse(hideSplash);
        }
      };
      return ConnectionMonitor;
    })();
  });
}).call(this);
