/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.database;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.commons.io.FileUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.server.ServerTestUtils;
import org.neo4j.server.database.CommunityDatabase;
import org.neo4j.server.database.Database;
import org.neo4j.server.logging.InMemoryAppender;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.ShellLobby;
import org.neo4j.shell.ShellSettings;

public class TestCommunityDatabase {
    private File databaseDirectory;
    private Database theDatabase;
    private boolean deletionFailureOk;

    @Before
    public void setup() throws Exception {
        this.databaseDirectory = ServerTestUtils.createTempDir();
        MapConfiguration conf = new MapConfiguration(new HashMap());
        conf.addProperty("org.neo4j.server.database.location", (Object)this.databaseDirectory.getAbsolutePath());
        this.theDatabase = new CommunityDatabase((Configuration)conf);
    }

    @After
    public void shutdownDatabase() throws Throwable {
        block2: {
            this.theDatabase.stop();
            try {
                FileUtils.forceDelete((File)this.databaseDirectory);
            }
            catch (IOException e) {
                if (this.deletionFailureOk) break block2;
                throw e;
            }
        }
    }

    @Test
    public void shouldLogOnSuccessfulStartup() throws Throwable {
        InMemoryAppender appender = new InMemoryAppender(Database.log);
        this.theDatabase.start();
        Assert.assertThat((Object)appender.toString(), (Matcher)Matchers.containsString((String)"Successfully started database"));
    }

    @Test
    public void shouldShutdownCleanly() throws Throwable {
        InMemoryAppender appender = new InMemoryAppender(Database.log);
        this.theDatabase.start();
        this.theDatabase.stop();
        Assert.assertThat((Object)appender.toString(), (Matcher)Matchers.containsString((String)"Successfully stopped database"));
    }

    @Test(expected=IllegalStateException.class)
    public void shouldComplainIfDatabaseLocationIsAlreadyInUse() throws Throwable {
        this.deletionFailureOk = true;
        this.theDatabase.start();
        MapConfiguration conf = new MapConfiguration(new HashMap());
        conf.addProperty("org.neo4j.server.database.location", (Object)this.databaseDirectory.getAbsolutePath());
        CommunityDatabase db = new CommunityDatabase((Configuration)conf);
        db.start();
    }

    @Test
    public void connectWithShellOnDefaultPortWhenNoShellConfigSupplied() throws Throwable {
        this.theDatabase.start();
        ShellLobby.newClient().shutdown();
    }

    @Test
    public void shouldBeAbleToOverrideShellConfig() throws Throwable {
        int customPort = this.findFreeShellPortToUse(8881);
        File tempDir = ServerTestUtils.createTempDir();
        File tuningProperties = new File(tempDir, "neo4j.properties");
        tuningProperties.createNewFile();
        ServerTestUtils.writePropertiesToFile(MapUtil.stringMap((String[])new String[]{ShellSettings.remote_shell_enabled.name(), "true", ShellSettings.remote_shell_port.name(), "" + customPort}), tuningProperties);
        MapConfiguration conf = new MapConfiguration(new HashMap());
        conf.addProperty("org.neo4j.server.database.location", (Object)tempDir.getAbsolutePath());
        conf.addProperty("org.neo4j.server.db.tuning.properties", (Object)tuningProperties.getAbsolutePath());
        CommunityDatabase otherDb = new CommunityDatabase((Configuration)conf);
        otherDb.start();
        ShellLobby.newClient((int)customPort).shutdown();
        otherDb.stop();
        FileUtils.forceDelete((File)tempDir);
    }

    @Test
    public void shouldBeAbleToGetLocation() throws Throwable {
        this.theDatabase.start();
        Assert.assertThat((Object)this.theDatabase.getLocation(), (Matcher)Matchers.is((Object)this.theDatabase.getGraph().getStoreDir()));
    }

    private int findFreeShellPortToUse(int startingPort) {
        try {
            while (true) {
                ShellLobby.newClient((int)startingPort).shutdown();
                ++startingPort;
            }
        }
        catch (ShellException e) {
            return startingPort;
        }
    }
}

