/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.discovery;

import java.net.URI;
import javax.ws.rs.core.Response;
import org.apache.commons.configuration.Configuration;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.server.rest.discovery.DiscoveryService;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.formats.JsonFormat;
import org.neo4j.test.server.EntityOutputFormat;

public class DiscoveryServiceTest {
    @Test
    public void shouldReturnValidJSONWithDataAndManagementUris() throws Exception {
        Configuration mockConfig = (Configuration)Mockito.mock(Configuration.class);
        String managementUri = "/management";
        Mockito.when((Object)mockConfig.getString("org.neo4j.server.webadmin.management.uri", "/db/manage")).thenReturn((Object)managementUri);
        String dataUri = "/data";
        Mockito.when((Object)mockConfig.getString("org.neo4j.server.webadmin.data.uri", "/db/data")).thenReturn((Object)dataUri);
        String baseUri = "http://www.example.com";
        DiscoveryService ds = new DiscoveryService(mockConfig, (OutputFormat)new EntityOutputFormat((RepresentationFormat)new JsonFormat(), new URI(baseUri), null));
        Response response = ds.getDiscoveryDocument();
        String json = new String((byte[])response.getEntity());
        Assert.assertNotNull((Object)json);
        Assert.assertThat((Object)json.length(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        Assert.assertThat((Object)json, (Matcher)Matchers.is((Matcher)Matchers.not((Object)"\"\"")));
        Assert.assertThat((Object)json, (Matcher)Matchers.is((Matcher)Matchers.not((Object)"null")));
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)("\"management\" : \"" + baseUri + managementUri + "\"")));
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)("\"data\" : \"" + baseUri + dataUri + "\"")));
    }

    @Ignore(value="Absolute URIs not supported in this config")
    @Test
    public void shouldReturnConfiguredUrlIfConfigIsAbsolute() throws Exception {
        Configuration mockConfig = (Configuration)Mockito.mock(Configuration.class);
        String managementUri = "http://absolutedomain/management";
        Mockito.when((Object)mockConfig.getString("org.neo4j.server.webadmin.management.uri", "/db/manage")).thenReturn((Object)managementUri);
        String dataUri = "http://absolutedomain/management";
        Mockito.when((Object)mockConfig.getString("org.neo4j.server.webadmin.data.uri", "/db/data")).thenReturn((Object)dataUri);
        String baseUri = "http://www.example.com";
        DiscoveryService ds = new DiscoveryService(mockConfig, (OutputFormat)new EntityOutputFormat((RepresentationFormat)new JsonFormat(), new URI(baseUri), null));
        Response response = ds.getDiscoveryDocument();
        String json = new String((byte[])response.getEntity());
        Assert.assertNotNull((Object)json);
        Assert.assertThat((Object)json.length(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        Assert.assertThat((Object)json, (Matcher)Matchers.is((Matcher)Matchers.not((Object)"\"\"")));
        Assert.assertThat((Object)json, (Matcher)Matchers.is((Matcher)Matchers.not((Object)"null")));
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)("\"management\" : \"" + managementUri + "\"")));
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)("\"data\" : \"" + dataUri + "\"")));
    }
}

