/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.webadmin.rest;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.neo4j.server.database.CypherExecutor;
import org.neo4j.server.database.Database;
import org.neo4j.server.webadmin.console.CypherSession;
import org.neo4j.server.webadmin.console.GremlinSession;
import org.neo4j.server.webadmin.console.ScriptSession;
import org.neo4j.server.webadmin.rest.ConsoleSessionFactory;
import org.neo4j.server.webadmin.rest.ShellSession;

public class SessionFactoryImpl
implements ConsoleSessionFactory {
    private HttpSession httpSession;
    private final CypherExecutor cypherExecutor;
    private Map<String, ConsoleEngineCreator> engineCreators = new HashMap<String, ConsoleEngineCreator>();

    public SessionFactoryImpl(HttpSession httpSession, List<String> supportedEngines, CypherExecutor cypherExecutor) {
        this.httpSession = httpSession;
        this.cypherExecutor = cypherExecutor;
        this.enableEngines(supportedEngines);
    }

    @Override
    public ScriptSession createSession(String engineName, Database database) {
        if (this.engineCreators.containsKey(engineName = engineName.toLowerCase())) {
            return this.getOrInstantiateSession(database, engineName + "-console-session", this.engineCreators.get(engineName));
        }
        throw new IllegalArgumentException("Unknown console engine '" + engineName + "'.");
    }

    @Override
    public Iterable<String> supportedEngines() {
        return this.engineCreators.keySet();
    }

    private ScriptSession getOrInstantiateSession(Database database, String key, ConsoleEngineCreator creator) {
        Object session = this.httpSession.getAttribute(key);
        if (session == null) {
            session = creator.newSession(database, this.cypherExecutor);
            this.httpSession.setAttribute(key, session);
        }
        return (ScriptSession)session;
    }

    private void enableEngines(List<String> supportedEngines) {
        for (String engineName : supportedEngines) {
            for (ConsoleEngineCreator creator : EnumSet.allOf(ConsoleEngineCreator.class)) {
                if (!creator.name().equalsIgnoreCase(engineName)) continue;
                this.engineCreators.put(engineName.toLowerCase(), creator);
            }
        }
    }

    public static enum ConsoleEngineCreator {
        GREMLIN{

            @Override
            ScriptSession newSession(Database database, CypherExecutor cypherExecutor) {
                return new GremlinSession(database);
            }
        }
        ,
        CYPHER{

            @Override
            ScriptSession newSession(Database database, CypherExecutor cypherExecutor) {
                return new CypherSession(cypherExecutor);
            }
        }
        ,
        SHELL{

            @Override
            ScriptSession newSession(Database database, CypherExecutor cypherExecutor) {
                return new ShellSession(database.getGraph());
            }
        };


        abstract ScriptSession newSession(Database var1, CypherExecutor var2);
    }
}

