/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.modules;

import java.lang.reflect.Field;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeDataSupport;
import org.apache.commons.configuration.MapConfiguration;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.jmx.JmxUtils;
import org.neo4j.jmx.Kernel;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.database.Database;
import org.neo4j.server.modules.WebAdminModule;
import org.neo4j.server.web.WebServer;
import org.neo4j.test.ReflectionUtil;
import org.rrd4j.core.RrdDb;

public class WebAdminModuleTest {
    @Test
    public void shouldRegisterASingleUri() throws Exception {
        WebServer webServer = (WebServer)Mockito.mock(WebServer.class);
        CommunityNeoServer neoServer = (CommunityNeoServer)Mockito.mock(CommunityNeoServer.class);
        Mockito.when((Object)neoServer.baseUri()).thenReturn((Object)new URI("http://localhost:7575"));
        Mockito.when((Object)neoServer.getWebServer()).thenReturn((Object)webServer);
        Database db = (Database)Mockito.mock(Database.class);
        AbstractGraphDatabase graph = (AbstractGraphDatabase)Mockito.mock(AbstractGraphDatabase.class);
        Mockito.when((Object)db.getGraph()).thenReturn((Object)graph);
        Kernel mockKernel = (Kernel)Mockito.mock(Kernel.class);
        ObjectName mockObjectName = (ObjectName)Mockito.mock(ObjectName.class);
        Mockito.when((Object)mockKernel.getMBeanQuery()).thenReturn((Object)mockObjectName);
        Mockito.when((Object)graph.getManagementBeans(Kernel.class)).thenReturn(Collections.singleton(mockKernel));
        Mockito.when((Object)neoServer.getDatabase()).thenReturn((Object)db);
        Mockito.when((Object)neoServer.getConfiguration()).thenReturn((Object)new MapConfiguration(new HashMap()));
        CompositeDataSupport result = (CompositeDataSupport)Mockito.mock(CompositeDataSupport.class);
        Mockito.when((Object)result.get("used")).thenReturn((Object)50L);
        Mockito.when((Object)result.get("max")).thenReturn((Object)1000L);
        MBeanServer mbeanServer = (MBeanServer)Mockito.mock(MBeanServer.class);
        Mockito.when((Object)mbeanServer.getAttribute((ObjectName)Matchers.any(ObjectName.class), (String)Matchers.eq((Object)"HeapMemoryUsage"))).thenReturn((Object)result);
        ReflectionUtil.setStaticFinalField((Field)JmxUtils.class.getDeclaredField("mbeanServer"), (Object)mbeanServer);
        WebAdminModule module = new WebAdminModule(webServer, neoServer.getConfiguration(), db);
        module.start(StringLogger.DEV_NULL);
        ((Database)Mockito.verify((Object)db)).setRrdDb((RrdDb)Matchers.any(RrdDb.class));
    }
}

