/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.NeoServer;
import org.neo4j.server.helpers.FunctionalTestHelper;
import org.neo4j.server.helpers.ServerBuilder;
import org.neo4j.server.helpers.ServerHelper;
import org.neo4j.server.rest.RESTDocsGenerator;
import org.neo4j.test.TestData;
import org.neo4j.test.server.ExclusiveServerTestBase;

public class AutoIndexWithNonDefaultConfigurationThroughRESTAPIFunctionalTest
extends ExclusiveServerTestBase {
    private static CommunityNeoServer server;
    private static FunctionalTestHelper functionalTestHelper;
    @Rule
    public TestData<RESTDocsGenerator> gen = TestData.producedThrough(RESTDocsGenerator.PRODUCER);

    @Before
    public void setUp() {
        ((RESTDocsGenerator)((Object)this.gen.get())).setSection("dev/rest-api");
    }

    @BeforeClass
    public static void allocateServer() throws IOException {
        server = ServerBuilder.server().withAutoIndexingEnabledForNodes("foo", "bar").build();
        server.start();
        functionalTestHelper = new FunctionalTestHelper((NeoServer)server);
    }

    @Before
    public void cleanTheDatabase() {
        ServerHelper.cleanTheDatabase((NeoServer)server);
    }

    @AfterClass
    public static void stopServer() {
        server.stop();
    }

    @Documented(value=" Create an auto index for nodes with specific configuration.\n")
    @Test
    public void shouldCreateANodeAutoIndexWithGivenFullTextConfiguration() throws Exception {
        String responseBody = ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(201).payload("{\"name\":\"node_auto_index\", \"config\":{\"type\":\"fulltext\",\"provider\":\"lucene\"}}").post(functionalTestHelper.nodeIndexUri()).entity();
        Assert.assertThat((Object)responseBody, (Matcher)Matchers.containsString((String)"\"type\" : \"fulltext\""));
    }

    @Documented(value=" Create an auto index for relationships with specific configuration.\n")
    @Test
    public void shouldCreateARelationshipAutoIndexWithGivenFullTextConfiguration() throws Exception {
        String responseBody = ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(201).payload("{\"name\":\"relationship_auto_index\", \"config\":{\"type\":\"fulltext\",\"provider\":\"lucene\"}}").post(functionalTestHelper.relationshipIndexUri()).entity();
        Assert.assertThat((Object)responseBody, (Matcher)Matchers.containsString((String)"\"type\" : \"fulltext\""));
    }
}

