/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.server.helpers.FunctionalTestHelper;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RESTDocsGenerator;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.server.rest.domain.GraphDbHelper;
import org.neo4j.server.rest.domain.JsonHelper;

public class ManageNodeFunctionalTest
extends AbstractRestFunctionalTestBase {
    private static final long NON_EXISTENT_NODE_ID = 999999L;
    private static String NODE_URI_PATTERN = "^.*/node/[0-9]+$";
    private static FunctionalTestHelper functionalTestHelper;
    private static GraphDbHelper helper;

    @BeforeClass
    public static void setupServer() throws IOException {
        functionalTestHelper = new FunctionalTestHelper(ManageNodeFunctionalTest.server());
        helper = functionalTestHelper.getGraphDbHelper();
    }

    @Before
    public void cleanTheDatabase() {
        this.cleanDatabase();
    }

    @Test
    public void create_Node() throws Exception {
        JaxRsResponse response = ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(201).expectedHeader("Location").post(functionalTestHelper.nodeUri()).response();
        Assert.assertTrue((boolean)response.getLocation().toString().matches(NODE_URI_PATTERN));
    }

    @Test
    public void create_Node_with_properties() throws Exception {
        JaxRsResponse response = ((RESTDocsGenerator)((Object)this.gen.get())).payload("{\"foo\" : \"bar\"}").expectedStatus(201).expectedHeader("Location").expectedHeader("Content-Length").post(functionalTestHelper.nodeUri()).response();
        Assert.assertTrue((boolean)response.getLocation().toString().matches(NODE_URI_PATTERN));
    }

    @Test
    public void create_Node_with_array_properties() throws Exception {
        String response = ((RESTDocsGenerator)((Object)this.gen.get())).payload("{\"foo\" : [1,2,3]}").expectedStatus(201).expectedHeader("Location").expectedHeader("Content-Length").post(functionalTestHelper.nodeUri()).response().getEntity();
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"[ 1, 2, 3 ]"));
    }

    @Documented(value=" Property values can not be null.\n \n This example shows the response you get when trying to set a property to\n +null+.\n")
    @Test
    public void shouldGet400WhenSupplyingNullValueForAProperty() throws Exception {
        ((RESTDocsGenerator)((Object)this.gen.get())).payload("{\"foo\":null}").expectedStatus(400).post(functionalTestHelper.nodeUri());
    }

    @Test
    public void shouldGet400WhenCreatingNodeMalformedProperties() throws Exception {
        JaxRsResponse response = this.sendCreateRequestToServer("this:::isNot::JSON}");
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }

    @Test
    public void shouldGet400WhenCreatingNodeUnsupportedNestedPropertyValues() throws Exception {
        JaxRsResponse response = this.sendCreateRequestToServer("{\"foo\" : {\"bar\" : \"baz\"}}");
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }

    private JaxRsResponse sendCreateRequestToServer(String json) {
        return RestRequest.req().post(functionalTestHelper.dataUri() + "node/", json);
    }

    private JaxRsResponse sendCreateRequestToServer() {
        return RestRequest.req().post(functionalTestHelper.dataUri() + "node/", null, MediaType.APPLICATION_JSON_TYPE);
    }

    @Test
    public void shouldGetValidLocationHeaderWhenCreatingNode() throws Exception {
        JaxRsResponse response = this.sendCreateRequestToServer();
        Assert.assertNotNull((Object)response.getLocation());
        Assert.assertTrue((boolean)response.getLocation().toString().startsWith(functionalTestHelper.dataUri() + "node/"));
    }

    @Test
    public void shouldGetASingleContentLengthHeaderWhenCreatingANode() {
        JaxRsResponse response = this.sendCreateRequestToServer();
        List contentLentgthHeaders = (List)response.getHeaders().get((Object)"Content-Length");
        Assert.assertNotNull((Object)contentLentgthHeaders);
        Assert.assertEquals((long)1L, (long)contentLentgthHeaders.size());
    }

    @Test
    public void shouldBeJSONContentTypeOnResponse() {
        JaxRsResponse response = this.sendCreateRequestToServer();
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
    }

    @Test
    public void shouldGetValidNodeRepresentationWhenCreatingNode() throws Exception {
        JaxRsResponse response = this.sendCreateRequestToServer();
        String entity = response.getEntity(String.class);
        Map map = JsonHelper.jsonToMap((String)entity);
        Assert.assertNotNull((Object)map);
        Assert.assertTrue((boolean)map.containsKey("self"));
    }

    @Documented(value=" Delete node.\n")
    @Test
    public void shouldRespondWith204WhenNodeDeleted() throws Exception {
        ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(204).delete(functionalTestHelper.dataUri() + "node/" + helper.createNode());
    }

    @Test
    public void shouldRespondWith404AndSensibleEntityBodyWhenNodeToBeDeletedCannotBeFound() throws Exception {
        JaxRsResponse response = this.sendDeleteRequestToServer(999999L);
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Map jsonMap = JsonHelper.jsonToMap((String)response.getEntity(String.class));
        Assert.assertThat((Object)jsonMap, (Matcher)Matchers.hasKey((Object)"message"));
        Assert.assertNotNull(jsonMap.get("message"));
    }

    @Documented(value=" Nodes with relationships can not be deleted.\n \n The relationships on a node has to be deleted before the node can be\n deleted.\n")
    @Test
    public void shouldRespondWith409AndSensibleEntityBodyWhenNodeCannotBeDeleted() throws Exception {
        long id = helper.createNode();
        helper.createRelationship("LOVES", id, helper.createNode());
        JaxRsResponse response = this.sendDeleteRequestToServer(id);
        Assert.assertEquals((long)409L, (long)response.getStatus());
        Map jsonMap = JsonHelper.jsonToMap((String)response.getEntity(String.class));
        Assert.assertThat((Object)jsonMap, (Matcher)Matchers.hasKey((Object)"message"));
        Assert.assertNotNull(jsonMap.get("message"));
        ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(409).delete(functionalTestHelper.dataUri() + "node/" + id);
    }

    @Test
    public void shouldRespondWith400IfInvalidJsonSentAsNodePropertiesDuringNodeCreation() throws URISyntaxException {
        String mangledJsonArray = "{\"myprop\":[1,2,\"three\"]}";
        JaxRsResponse response = this.sendCreateRequestToServer(mangledJsonArray);
        Assert.assertEquals((long)400L, (long)response.getStatus());
        Assert.assertEquals((Object)"text/plain", (Object)response.getType().toString());
        Assert.assertThat((Object)response.getEntity(String.class), (Matcher)Matchers.containsString((String)mangledJsonArray));
    }

    @Test
    public void shouldRespondWith400IfInvalidJsonSentAsNodeProperty() throws URISyntaxException {
        URI nodeLocation = this.sendCreateRequestToServer().getLocation();
        String mangledJsonArray = "[1,2,\"three\"]";
        JaxRsResponse response = RestRequest.req().put(nodeLocation.toString() + "/properties/myprop", mangledJsonArray);
        Assert.assertEquals((long)400L, (long)response.getStatus());
        Assert.assertEquals((Object)"text/plain", (Object)response.getType().toString());
        Assert.assertThat((Object)response.getEntity(String.class), (Matcher)Matchers.containsString((String)mangledJsonArray));
        response.close();
    }

    @Test
    public void shouldRespondWith400IfInvalidJsonSentAsNodeProperties() throws URISyntaxException {
        URI nodeLocation = this.sendCreateRequestToServer().getLocation();
        String mangledJsonProperties = "{\"a\":\"b\", \"c\":[1,2,\"three\"]}";
        JaxRsResponse response = RestRequest.req().put(nodeLocation.toString() + "/properties", mangledJsonProperties);
        Assert.assertEquals((long)400L, (long)response.getStatus());
        Assert.assertEquals((Object)"text/plain", (Object)response.getType().toString());
        Assert.assertThat((Object)response.getEntity(String.class), (Matcher)Matchers.containsString((String)mangledJsonProperties));
        response.close();
    }

    private JaxRsResponse sendDeleteRequestToServer(long id) throws Exception {
        return RestRequest.req().delete(functionalTestHelper.dataUri() + "node/" + id);
    }
}

