/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.AutoIndexer;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.RelationshipAutoIndexer;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.server.database.Database;

public class GraphDbHelper {
    private final Database database;

    public GraphDbHelper(Database database) {
        this.database = database;
    }

    public int getNumberOfNodes() {
        return this.numberOfEntitiesFor(Node.class);
    }

    public int getNumberOfRelationships() {
        return this.numberOfEntitiesFor(Relationship.class);
    }

    private int numberOfEntitiesFor(Class<? extends PropertyContainer> type) {
        return (int)this.database.getGraph().getNodeManager().getNumberOfIdsInUse(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getNodeProperties(long nodeId) {
        Transaction tx = this.database.getGraph().beginTx();
        try {
            Node node = this.database.getGraph().getNodeById(nodeId);
            HashMap<String, Object> allProperties = new HashMap<String, Object>();
            for (String propertyKey : node.getPropertyKeys()) {
                allProperties.put(propertyKey, node.getProperty(propertyKey));
            }
            tx.success();
            HashMap<String, Object> hashMap = allProperties;
            return hashMap;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNodeProperties(long nodeId, Map<String, Object> properties) {
        Transaction tx = this.database.getGraph().beginTx();
        try {
            Node node = this.database.getGraph().getNodeById(nodeId);
            for (Map.Entry<String, Object> propertyEntry : properties.entrySet()) {
                node.setProperty(propertyEntry.getKey(), propertyEntry.getValue());
            }
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createNode() {
        Transaction tx = this.database.getGraph().beginTx();
        try {
            Node node = this.database.getGraph().createNode();
            tx.success();
            long l = node.getId();
            return l;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createNode(Map<String, Object> properties) {
        Transaction tx = this.database.getGraph().beginTx();
        try {
            Node node = this.database.getGraph().createNode();
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                node.setProperty(entry.getKey(), entry.getValue());
            }
            tx.success();
            long l = node.getId();
            return l;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNode(long id) {
        Transaction tx = this.database.getGraph().beginTx();
        try {
            Node node = this.database.getGraph().getNodeById(id);
            node.delete();
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createRelationship(String type, long startNodeId, long endNodeId) {
        Transaction tx = this.database.getGraph().beginTx();
        try {
            Node startNode = this.database.getGraph().getNodeById(startNodeId);
            Node endNode = this.database.getGraph().getNodeById(endNodeId);
            Relationship relationship = startNode.createRelationshipTo(endNode, (RelationshipType)DynamicRelationshipType.withName((String)type));
            tx.success();
            long l = relationship.getId();
            return l;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createRelationship(String type) {
        Transaction tx = this.database.getGraph().beginTx();
        try {
            Node startNode = this.database.getGraph().createNode();
            Node endNode = this.database.getGraph().createNode();
            Relationship relationship = startNode.createRelationshipTo(endNode, (RelationshipType)DynamicRelationshipType.withName((String)type));
            tx.success();
            long l = relationship.getId();
            return l;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRelationshipProperties(long relationshipId, Map<String, Object> properties) {
        Transaction tx = this.database.getGraph().beginTx();
        try {
            Relationship relationship = this.database.getGraph().getRelationshipById(relationshipId);
            for (Map.Entry<String, Object> propertyEntry : properties.entrySet()) {
                relationship.setProperty(propertyEntry.getKey(), propertyEntry.getValue());
            }
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getRelationshipProperties(long relationshipId) {
        Transaction tx = this.database.getGraph().beginTx();
        try {
            Relationship relationship = this.database.getGraph().getRelationshipById(relationshipId);
            HashMap<String, Object> allProperties = new HashMap<String, Object>();
            for (String propertyKey : relationship.getPropertyKeys()) {
                allProperties.put(propertyKey, relationship.getProperty(propertyKey));
            }
            tx.success();
            HashMap<String, Object> hashMap = allProperties;
            return hashMap;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Relationship getRelationship(long relationshipId) {
        Transaction tx = this.database.getGraph().beginTx();
        try {
            Relationship relationship = this.database.getGraph().getRelationshipById(relationshipId);
            tx.success();
            Relationship relationship2 = relationship;
            return relationship2;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNodeToIndex(String indexName, String key, Object value, long id) {
        Index index = this.database.getNodeIndex(indexName);
        Transaction tx = this.database.getGraph().beginTx();
        try {
            index.add((PropertyContainer)this.database.getGraph().getNodeById(id), key, value);
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    public void enableNodeAutoIndexingFor(String key) {
        AutoIndexer nodeAutoIndexer = this.database.getGraph().index().getNodeAutoIndexer();
        nodeAutoIndexer.startAutoIndexingProperty(key);
        nodeAutoIndexer.setEnabled(true);
    }

    public void enableRelationshipAutoIndexingFor(String key) {
        RelationshipAutoIndexer relAutoIndexer = this.database.getGraph().index().getRelationshipAutoIndexer();
        relAutoIndexer.startAutoIndexingProperty(key);
        relAutoIndexer.setEnabled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Long> queryIndexedNodes(String indexName, String key, Object value) {
        Index index = this.database.getNodeIndex(indexName);
        Transaction tx = this.database.getGraph().beginTx();
        try {
            ArrayList<Long> result = new ArrayList<Long>();
            for (Node node : index.query(key, value)) {
                result.add(node.getId());
            }
            tx.success();
            ArrayList<Long> arrayList = result;
            return arrayList;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Long> getIndexedNodes(String indexName, String key, Object value) {
        Index index = this.database.getNodeIndex(indexName);
        Transaction tx = this.database.getGraph().beginTx();
        try {
            ArrayList<Long> result = new ArrayList<Long>();
            for (Node node : index.get(key, value)) {
                result.add(node.getId());
            }
            tx.success();
            ArrayList<Long> arrayList = result;
            return arrayList;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Long> getIndexedRelationships(String indexName, String key, Object value) {
        Index index = this.database.getRelationshipIndex(indexName);
        Transaction tx = this.database.getGraph().beginTx();
        try {
            ArrayList<Long> result = new ArrayList<Long>();
            for (Relationship relationship : index.get(key, value)) {
                result.add(relationship.getId());
            }
            tx.success();
            ArrayList<Long> arrayList = result;
            return arrayList;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRelationshipToIndex(String indexName, String key, String value, long relationshipId) {
        Index index = this.database.getRelationshipIndex(indexName);
        Transaction tx = this.database.getGraph().beginTx();
        try {
            index.add((PropertyContainer)this.database.getGraph().getRelationshipById(relationshipId), key, (Object)value);
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    public String[] getNodeIndexes() {
        return this.database.getIndexManager().nodeIndexNames();
    }

    public Index<Node> getNodeIndex(String indexName) {
        return this.database.getIndexManager().forNodes(indexName);
    }

    public Index<Node> createNodeFullTextIndex(String named) {
        return this.database.getIndexManager().forNodes(named, MapUtil.stringMap((String[])new String[]{"provider", "lucene", "type", "fulltext"}));
    }

    public Index<Node> createNodeIndex(String named) {
        return this.database.getIndexManager().forNodes(named);
    }

    public String[] getRelationshipIndexes() {
        return this.database.getIndexManager().relationshipIndexNames();
    }

    public long getReferenceNode() {
        return this.database.getGraph().getReferenceNode().getId();
    }

    public Index<Relationship> getRelationshipIndex(String indexName) {
        return this.database.getIndexManager().forRelationships(indexName);
    }

    public Index<Relationship> createRelationshipFullTextIndex(String named) {
        return this.database.getIndexManager().forRelationships(named, MapUtil.stringMap((String[])new String[]{"provider", "lucene", "type", "fulltext"}));
    }

    public Index<Relationship> createRelationshipIndex(String named) {
        return this.database.getIndexManager().forRelationships(named);
    }
}

