/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.server.rest.repr.ExceptionRepresentation;
import org.neo4j.server.rest.repr.InputFormat;
import org.neo4j.server.rest.repr.MapRepresentation;
import org.neo4j.server.rest.repr.MediaTypeNotSupportedException;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationFormatRepository;
import org.neo4j.server.rest.repr.ValueRepresentation;

public class RepresentationFormatRepositoryTest {
    private final RepresentationFormatRepository repository = new RepresentationFormatRepository(null);

    @Test
    public void canProvideJsonFormat() throws Exception {
        Assert.assertNotNull((Object)this.repository.inputFormat(MediaType.valueOf((String)"application/json")));
    }

    @Test
    public void canProvideUTF8EncodedJsonFormat() throws Exception {
        Assert.assertNotNull((Object)this.repository.inputFormat(MediaType.valueOf((String)"application/json;charset=UTF-8")));
    }

    @Test(expected=MediaTypeNotSupportedException.class)
    public void canNotGetInputFormatBasedOnWildcardMediaType() throws Exception {
        InputFormat format = this.repository.inputFormat(MediaType.WILDCARD_TYPE);
        format.readValue("foo");
        Assert.fail((String)("Got InputFormat based on wild card type: " + format));
    }

    @Test
    public void canProvideJsonOutputFormat() throws Exception {
        OutputFormat format = this.repository.outputFormat(Arrays.asList(MediaType.APPLICATION_JSON_TYPE), null, null);
        Assert.assertNotNull((Object)format);
        Assert.assertEquals((Object)"\"test\"", (Object)format.format((Representation)ValueRepresentation.string((String)"test")));
    }

    @Test
    public void cannotProvideStreamingForOtherMediaTypes() throws Exception {
        Response.ResponseBuilder responseBuilder = (Response.ResponseBuilder)Mockito.mock(Response.ResponseBuilder.class);
        Mockito.when((Object)responseBuilder.entity((Object)Matchers.anyString())).thenReturn((Object)responseBuilder);
        ((Response.ResponseBuilder)Mockito.verify((Object)responseBuilder, (VerificationMode)Mockito.never())).entity(Matchers.isA(StreamingOutput.class));
        Mockito.when((Object)responseBuilder.type((MediaType)Mockito.any())).thenReturn((Object)responseBuilder);
        Mockito.when((Object)responseBuilder.header("Content-Encoding", (Object)"UTF-8")).thenReturn((Object)responseBuilder);
        Mockito.when((Object)responseBuilder.build()).thenReturn(null);
        OutputFormat format = this.repository.outputFormat(Arrays.asList(MediaType.TEXT_HTML_TYPE), new URI("http://some.host"), this.streamingHeader());
        Assert.assertNotNull((Object)format);
        format.response(responseBuilder, (Representation)new ExceptionRepresentation((Throwable)new RuntimeException()));
    }

    @Test
    public void canProvideStreamingJsonOutputFormat() throws Exception {
        Response response = (Response)Mockito.mock(Response.class);
        AtomicReference<StreamingOutput> ref = new AtomicReference<StreamingOutput>();
        Response.ResponseBuilder responseBuilder = this.mockResponsBuilder(response, ref);
        OutputFormat format = this.repository.outputFormat(Arrays.asList(MediaType.APPLICATION_JSON_TYPE), null, this.streamingHeader());
        Assert.assertNotNull((Object)format);
        Response returnedResponse = format.response(responseBuilder, (Representation)new MapRepresentation(MapUtil.map((Object[])new Object[]{"a", "test"})));
        Assert.assertSame((Object)response, (Object)returnedResponse);
        StreamingOutput streamingOutput = ref.get();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        streamingOutput.write((OutputStream)baos);
        Assert.assertEquals((Object)"{\"a\":\"test\"}", (Object)baos.toString());
    }

    private Response.ResponseBuilder mockResponsBuilder(Response response, final AtomicReference<StreamingOutput> ref) {
        final Response.ResponseBuilder responseBuilder = (Response.ResponseBuilder)Mockito.mock(Response.ResponseBuilder.class);
        Mockito.when((Object)responseBuilder.entity(Mockito.isA(StreamingOutput.class))).thenAnswer((Answer)new Answer<Response.ResponseBuilder>(){

            public Response.ResponseBuilder answer(InvocationOnMock invocationOnMock) throws Throwable {
                ref.set((StreamingOutput)invocationOnMock.getArguments()[0]);
                return responseBuilder;
            }
        });
        Mockito.when((Object)responseBuilder.type((MediaType)Mockito.any())).thenReturn((Object)responseBuilder);
        Mockito.when((Object)responseBuilder.header("Content-Encoding", (Object)"UTF-8")).thenReturn((Object)responseBuilder);
        Mockito.when((Object)responseBuilder.build()).thenReturn((Object)response);
        return responseBuilder;
    }

    private MultivaluedMap<String, String> streamingHeader() {
        MultivaluedMap headers = (MultivaluedMap)Mockito.mock(MultivaluedMap.class);
        Mockito.when((Object)headers.getFirst((Object)"X-Stream")).thenReturn((Object)"true");
        return headers;
    }
}

