/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr.formats;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.MappingSerializer;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.ValueRepresentation;
import org.neo4j.server.rest.repr.formats.CompactJsonFormat;

public class CompactJsonFormatTest {
    private OutputFormat json;

    @Before
    public void createOutputFormat() throws Exception {
        this.json = new OutputFormat((RepresentationFormat)new CompactJsonFormat(), new URI("http://localhost/"), null);
    }

    @Test
    public void canFormatString() throws Exception {
        String entity = this.json.format((Representation)ValueRepresentation.string((String)"expected value"));
        Assert.assertEquals((Object)entity, (Object)"\"expected value\"");
    }

    @Test
    public void canFormatListOfStrings() throws Exception {
        String entity = this.json.format((Representation)ListRepresentation.strings((String[])new String[]{"hello", "world"}));
        String expectedString = JsonHelper.createJsonFrom(Arrays.asList("hello", "world"));
        Assert.assertEquals((Object)expectedString, (Object)entity);
    }

    @Test
    public void canFormatInteger() throws Exception {
        String entity = this.json.format((Representation)ValueRepresentation.number((int)10));
        Assert.assertEquals((Object)"10", (Object)entity);
    }

    @Test
    public void canFormatObjectWithStringField() throws Exception {
        String entity = this.json.format((Representation)new MappingRepresentation("string"){

            protected void serialize(MappingSerializer serializer) {
                serializer.putString("key", "expected string");
            }
        });
        Assert.assertEquals((Object)JsonHelper.createJsonFrom(Collections.singletonMap("key", "expected string")), (Object)entity);
    }
}

