/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security;

import java.io.File;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.server.security.KeyStoreFactory;
import org.neo4j.server.security.KeyStoreInformation;
import org.neo4j.server.security.SslCertificateFactory;

public class TestKeyStoreFactory {
    @Test
    public void shouldCreateKeyStoreForGivenKeyPair() throws Exception {
        File cPath = File.createTempFile("cert", "test");
        File pkPath = File.createTempFile("privatekey", "test");
        File keyStorePath = File.createTempFile("keyStore", "test");
        SslCertificateFactory ssl = new SslCertificateFactory();
        ssl.createSelfSignedCertificate(cPath, pkPath, "asd");
        KeyStoreFactory keyStoreFactory = new KeyStoreFactory();
        KeyStoreInformation ks = keyStoreFactory.createKeyStore(keyStorePath, pkPath, cPath);
        File keyStoreFile = new File(ks.getKeyStorePath());
        Assert.assertThat((Object)keyStoreFile.exists(), (Matcher)Matchers.is((Object)true));
    }
}

