/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.webadmin.logging;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Scanner;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.server.NeoServer;
import org.neo4j.server.helpers.FunctionalTestHelper;
import org.neo4j.server.helpers.ServerBuilder;
import org.neo4j.server.helpers.ServerHelper;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.server.startup.healthcheck.HTTPLoggingPreparednessRule;
import org.neo4j.server.startup.healthcheck.HTTPLoggingPreparednessRuleTest;
import org.neo4j.server.startup.healthcheck.StartupHealthCheckFailedException;
import org.neo4j.server.startup.healthcheck.StartupHealthCheckRule;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.server.ExclusiveServerTestBase;

public class HTTPLoggingFunctionalTest
extends ExclusiveServerTestBase {
    private NeoServer server;
    private static File logDirectory = null;

    @Before
    public void setUp() throws IOException {
        ServerHelper.cleanTheDatabase(this.server);
        this.removeHttpLogs();
    }

    private void removeHttpLogs() throws IOException {
        if (logDirectory != null && logDirectory.exists()) {
            FileUtils.deleteDirectory((File)logDirectory);
        }
    }

    @After
    public void stopServer() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    @Test
    public void givenExplicitlyDisabledServerLoggingConfigurationShouldNotLogAccesses() throws Exception {
        this.server = ServerBuilder.server().withDefaultDatabaseTuning().withProperty("org.neo4j.server.http.log.enabled", "false").build();
        this.server.start();
        FunctionalTestHelper functionalTestHelper = new FunctionalTestHelper(this.server);
        String query = "?implicitlyDisabled" + UUID.randomUUID().toString();
        JaxRsResponse response = new RestRequest().get(functionalTestHelper.webAdminUri() + query);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        response.close();
        Assert.assertFalse((boolean)this.occursIn(query, new File(logDirectory + File.separator + "http.log")));
    }

    @Test
    public void givenExplicitlyEnabledServerLoggingConfigurationShouldLogAccess() throws Exception {
        logDirectory = TargetDirectory.forTest(this.getClass()).directory("logdir");
        FileUtils.forceMkdir((File)logDirectory);
        File confDir = TargetDirectory.forTest(this.getClass()).directory("confdir");
        FileUtils.forceMkdir((File)confDir);
        File configFile = HTTPLoggingPreparednessRuleTest.createConfigFile(HTTPLoggingPreparednessRuleTest.createLogbackConfigXml(logDirectory), confDir);
        this.server = ServerBuilder.server().withDefaultDatabaseTuning().withProperty("org.neo4j.server.http.log.enabled", "true").withProperty("org.neo4j.server.http.log.config", configFile.getPath()).build();
        this.server.start();
        FunctionalTestHelper functionalTestHelper = new FunctionalTestHelper(this.server);
        String query = "?explicitlyEnabled=" + UUID.randomUUID().toString();
        JaxRsResponse response = new RestRequest().get(functionalTestHelper.webAdminUri() + query);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        response.close();
        File outputLog = new File(logDirectory + File.separator + "http.log");
        Assert.assertTrue((boolean)this.occursIn(query, outputLog));
    }

    @Test
    public void givenConfigurationWithUnwritableLogDirectoryShouldFailToStartServer() throws Exception {
        File confDir = TargetDirectory.forTest(this.getClass()).directory("confdir");
        FileUtils.forceMkdir((File)confDir);
        File unwritableLogDir = this.createUnwritableDirectory();
        File configFile = HTTPLoggingPreparednessRuleTest.createConfigFile(HTTPLoggingPreparednessRuleTest.createLogbackConfigXml(unwritableLogDir), confDir);
        this.server = ServerBuilder.server().withDefaultDatabaseTuning().withStartupHealthCheckRules(new StartupHealthCheckRule[]{new HTTPLoggingPreparednessRule()}).withProperty("org.neo4j.server.http.log.enabled", "true").withProperty("org.neo4j.server.http.log.config", configFile.getPath()).build();
        try {
            this.server.start();
            Assert.fail((String)"should have thrown exception");
        }
        catch (StartupHealthCheckFailedException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)JUnitMatchers.containsString((String)String.format("HTTP log file [%s] does not exist", unwritableLogDir.getAbsolutePath() + File.separator + "http.log")));
        }
    }

    private File createUnwritableDirectory() {
        File file;
        if (GraphDatabaseSetting.osIsWindows()) {
            file = new File("\\\\" + UUID.randomUUID().toString() + "\\");
        } else {
            TargetDirectory targetDirectory = TargetDirectory.forTest(this.getClass());
            file = targetDirectory.file("unwritable-" + System.currentTimeMillis());
            file.mkdirs();
            file.setWritable(false, false);
        }
        return file;
    }

    private boolean occursIn(String lookFor, File file) throws FileNotFoundException {
        if (!file.exists()) {
            return false;
        }
        boolean result = false;
        Scanner scanner = new Scanner(file);
        while (scanner.hasNext()) {
            if (!scanner.next().contains(lookFor)) continue;
            result = true;
        }
        scanner.close();
        return result;
    }
}

