/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.database;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.server.database.GraphDatabaseFactory;
import org.neo4j.server.logging.Logger;
import org.neo4j.server.statistic.StatisticCollector;
import org.neo4j.shell.ShellSettings;
import org.rrd4j.core.RrdDb;

public class Database
implements Lifecycle {
    public static Logger log = Logger.getLogger(Database.class);
    @Deprecated
    public AbstractGraphDatabase graph;
    private RrdDb rrdDb;
    private final StatisticCollector statisticCollector = new StatisticCollector();

    @Deprecated
    public Database() {
    }

    @Deprecated
    public Database(AbstractGraphDatabase db) {
        this.graph = db;
    }

    @Deprecated
    public Database(GraphDatabaseFactory factory, String databaseStoreDirectory) {
        this((AbstractGraphDatabase)Database.createDatabase(factory, databaseStoreDirectory, null));
        log.warn("No database tuning properties set in the property file, using defaults. Please specify the performance properties file with org.neo4j.server.db.tuning.properties in the server properties file [%s].", System.getProperty("org.neo4j.server.properties"));
    }

    @Deprecated
    public Database(GraphDatabaseFactory factory, String databaseStoreDirectory, Map<String, String> databaseTuningProperties) {
        this((AbstractGraphDatabase)Database.createDatabase(factory, databaseStoreDirectory, databaseTuningProperties));
    }

    private static GraphDatabaseAPI createDatabase(GraphDatabaseFactory factory, String databaseStoreDirectory, Map<String, String> databaseProperties) {
        log.info("Using database at " + databaseStoreDirectory, new Object[0]);
        if (databaseProperties == null) {
            databaseProperties = new HashMap<String, String>();
        }
        Database.putIfAbsent(databaseProperties, ShellSettings.remote_shell_enabled.name(), "true");
        Database.putIfAbsent(databaseProperties, GraphDatabaseSettings.keep_logical_logs.name(), "true");
        databaseProperties.put(GraphDatabaseSettings.udc_source.name(), "server");
        return factory.createDatabase(databaseStoreDirectory, databaseProperties);
    }

    private static void putIfAbsent(Map<String, String> databaseProperties, String configKey, String configValue) {
        if (databaseProperties.get(configKey) == null) {
            databaseProperties.put(configKey, configValue);
        }
    }

    public String getLocation() {
        return this.graph.getStoreDir();
    }

    public Index<Relationship> getRelationshipIndex(String name) {
        RelationshipIndex index = this.graph.index().forRelationships(name);
        if (index == null) {
            throw new RuntimeException("No index for [" + name + "]");
        }
        return index;
    }

    public Index<Node> getNodeIndex(String name) {
        Index index = this.graph.index().forNodes(name);
        if (index == null) {
            throw new RuntimeException("No index for [" + name + "]");
        }
        return index;
    }

    public IndexManager getIndexManager() {
        return this.graph.index();
    }

    public GraphDatabaseAPI getGraph() {
        return this.graph;
    }

    @Deprecated
    public RrdDb rrdDb() {
        return this.rrdDb;
    }

    @Deprecated
    public void setRrdDb(RrdDb rrdDb) {
        this.rrdDb = rrdDb;
    }

    @Deprecated
    public StatisticCollector statisticCollector() {
        return this.statisticCollector;
    }

    public void init() throws Throwable {
    }

    public void start() throws Throwable {
    }

    public void stop() throws Throwable {
    }

    public void shutdown() throws Throwable {
    }

    @Deprecated
    public void startup() {
        try {
            this.start();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

