/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import com.sun.jersey.api.core.HttpContext;
import java.net.URI;
import java.net.URISyntaxException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.Provider;
import org.neo4j.server.database.AbstractInjectableProvider;
import org.neo4j.server.rest.repr.MediaTypeNotSupportedException;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.RepresentationFormatRepository;

@Provider
public final class OutputFormatProvider
extends AbstractInjectableProvider<OutputFormat> {
    private final RepresentationFormatRepository repository;

    public OutputFormatProvider(RepresentationFormatRepository repository) {
        super(OutputFormat.class);
        this.repository = repository;
    }

    public OutputFormat getValue(HttpContext context) {
        try {
            return this.repository.outputFormat(context.getRequest().getAcceptableMediaTypes(), this.getBaseUri(context), (MultivaluedMap<String, String>)context.getRequest().getRequestHeaders());
        }
        catch (MediaTypeNotSupportedException e) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).entity((Object)e.getMessage()).build());
        }
        catch (URISyntaxException e) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build());
        }
    }

    private URI getBaseUri(HttpContext context) throws URISyntaxException {
        UriBuilder builder = UriBuilder.fromUri((URI)context.getRequest().getBaseUri());
        ForwardedHost forwardedHost = new ForwardedHost(context.getRequest().getHeaderValue("X-Forwarded-Host"));
        ForwardedProto xForwardedProto = new ForwardedProto(context.getRequest().getHeaderValue("X-Forwarded-Proto"));
        if (forwardedHost.isValid()) {
            builder.host(forwardedHost.getHost()).port(forwardedHost.getPort());
        }
        if (xForwardedProto.isValid()) {
            builder.scheme(xForwardedProto.getScheme());
        }
        return builder.build(new Object[0]);
    }

    private class ForwardedProto {
        private final String headerValue;

        public ForwardedProto(String headerValue) {
            this.headerValue = headerValue != null ? headerValue : "";
        }

        public boolean isValid() {
            return this.headerValue.toLowerCase().equals("http") || this.headerValue.toLowerCase().equals("https");
        }

        public String getScheme() {
            return this.headerValue;
        }
    }

    private class ForwardedHost {
        private String host;
        private int port;
        private boolean isValid = false;

        public ForwardedHost(String headerValue) {
            if (headerValue == null) {
                this.isValid = false;
                return;
            }
            String firstAddress = headerValue.split(",")[0].trim();
            try {
                UriBuilder.fromUri((String)firstAddress).build(new Object[0]);
            }
            catch (IllegalArgumentException ex) {
                this.isValid = false;
                return;
            }
            String[] strings = firstAddress.split(":");
            if (strings.length > 0) {
                this.host = strings[0];
                this.isValid = true;
            }
            if (strings.length > 1) {
                this.port = Integer.valueOf(strings[1]);
                this.isValid = true;
            }
            if (strings.length > 2) {
                this.isValid = true;
            }
        }

        public boolean isValid() {
            return this.isValid && this.port >= 0;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }
    }
}

