/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.neo4j.server.rest.JSONPrettifier;

class DocumentationData {
    private String payload;
    private MediaType payloadType = MediaType.APPLICATION_JSON_TYPE;
    public String title;
    public String description;
    public String uri;
    public String method;
    public int status;
    public String entity;
    public Map<String, String> requestHeaders;
    public Map<String, String> responseHeaders;
    public boolean ignore;

    DocumentationData() {
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public String getPayload() {
        if (this.payload != null && !this.payload.trim().isEmpty() && MediaType.APPLICATION_JSON_TYPE.equals((Object)this.payloadType)) {
            System.out.println("prettifying: ");
            System.out.println(this.payload);
            return JSONPrettifier.parse(this.payload);
        }
        return this.payload;
    }

    public String getPrettifiedEntity() {
        return JSONPrettifier.parse(this.entity);
    }

    public void setPayloadType(MediaType payloadType) {
        this.payloadType = payloadType;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setStatus(int responseCode) {
        this.status = responseCode;
    }

    public void setEntity(String entity) {
        this.entity = entity;
    }

    public void setResponseHeaders(Map<String, String> response) {
        this.responseHeaders = response;
    }

    public void setRequestHeaders(Map<String, String> request) {
        this.requestHeaders = request;
    }

    public void setIgnore() {
        this.ignore = true;
    }

    public String toString() {
        return "DocumentationData [payload=" + this.payload + ", title=" + this.title + ", description=" + this.description + ", uri=" + this.uri + ", method=" + this.method + ", status=" + this.status + ", entity=" + this.entity + ", requestHeaders=" + this.requestHeaders + ", responseHeaders=" + this.responseHeaders + "]";
    }
}

