/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.server.rest.DocumentationData;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.test.AsciiDocGenerator;
import org.neo4j.test.GraphDefinition;
import org.neo4j.test.TestData;
import org.neo4j.visualization.asciidoc.AsciidocHelper;

public class RESTDocsGenerator
extends AsciiDocGenerator {
    private static final String EQUAL_SIGNS = "======";
    private static final ClientRequest.Builder REQUEST_BUILDER = ClientRequest.create();
    private static final List<String> RESPONSE_HEADERS = Arrays.asList("Content-Type", "Location");
    private static final List<String> REQUEST_HEADERS = Arrays.asList("Content-Type", "Accept");
    public static final TestData.Producer<RESTDocsGenerator> PRODUCER = new TestData.Producer<RESTDocsGenerator>(){

        public RESTDocsGenerator create(GraphDefinition graph, String title, String documentation) {
            RESTDocsGenerator gen = RESTDocsGenerator.create(title);
            gen.description(documentation);
            return gen;
        }

        public void destroy(RESTDocsGenerator product, boolean successful) {
        }
    };
    private int expectedResponseStatus = -1;
    private MediaType expectedMediaType = MediaType.APPLICATION_JSON_TYPE;
    private MediaType payloadMediaType = MediaType.APPLICATION_JSON_TYPE;
    private final List<String> expectedHeaderFields = new ArrayList<String>();
    private String payload;
    private Map<String, String> addedRequestHeaders = new TreeMap<String, String>();
    private boolean noDoc;
    private int headingLevel = 3;

    public static RESTDocsGenerator create(String title) {
        if (title == null) {
            throw new IllegalArgumentException("The title can not be null");
        }
        return new RESTDocsGenerator(title);
    }

    private RESTDocsGenerator(String ti) {
        super(ti, "rest-api");
    }

    public RESTDocsGenerator expectedStatus(int expectedResponseStatus) {
        this.expectedResponseStatus = expectedResponseStatus;
        return this;
    }

    public RESTDocsGenerator expectedStatus(ClientResponse.Status expectedStatus) {
        this.expectedResponseStatus = expectedStatus.getStatusCode();
        return this;
    }

    public RESTDocsGenerator expectedType(MediaType expectedMediaType) {
        this.expectedMediaType = expectedMediaType;
        return this;
    }

    public RESTDocsGenerator payloadType(MediaType payloadMediaType) {
        this.payloadMediaType = payloadMediaType;
        return this;
    }

    public RESTDocsGenerator withHeader(String key, String value) {
        this.addedRequestHeaders.put(key, value);
        return this;
    }

    public RESTDocsGenerator payload(String payload) {
        this.payload = payload;
        return this;
    }

    public RESTDocsGenerator noDoc() {
        this.noDoc = true;
        return this;
    }

    public RESTDocsGenerator docHeadingLevel(int headingLevel) {
        if (headingLevel < 1 || headingLevel > EQUAL_SIGNS.length()) {
            throw new IllegalArgumentException("Heading level out of bounds: " + headingLevel);
        }
        this.headingLevel = headingLevel;
        return this;
    }

    public RESTDocsGenerator expectedHeader(String expectedHeaderField) {
        this.expectedHeaderFields.add(expectedHeaderField);
        return this;
    }

    public ResponseEntity request(ClientRequest request) {
        return this.retrieveResponse(this.title, this.description, request.getURI().toString(), this.expectedResponseStatus, this.expectedMediaType, this.expectedHeaderFields, request);
    }

    public RESTDocsGenerator description(String description) {
        return (RESTDocsGenerator)super.description(description);
    }

    public ResponseEntity get(String uri) {
        return this.retrieveResponseFromRequest(this.title, this.description, "GET", uri, this.expectedResponseStatus, this.expectedMediaType, this.expectedHeaderFields);
    }

    public ResponseEntity post(String uri) {
        return this.retrieveResponseFromRequest(this.title, this.description, "POST", uri, this.payload, this.payloadMediaType, this.expectedResponseStatus, this.expectedMediaType, this.expectedHeaderFields);
    }

    public ResponseEntity put(String uri) {
        return this.retrieveResponseFromRequest(this.title, this.description, "PUT", uri, this.payload, this.payloadMediaType, this.expectedResponseStatus, this.expectedMediaType, this.expectedHeaderFields);
    }

    public ResponseEntity delete(String uri) {
        return this.retrieveResponseFromRequest(this.title, this.description, "DELETE", uri, this.payload, this.payloadMediaType, this.expectedResponseStatus, this.expectedMediaType, this.expectedHeaderFields);
    }

    private ResponseEntity retrieveResponseFromRequest(String title, String description, String method, String uri, int responseCode, MediaType accept, List<String> headerFields) {
        ClientRequest request;
        try {
            request = ((ClientRequest.Builder)this.withHeaders(REQUEST_BUILDER).accept(new MediaType[]{accept})).build(new URI(uri), method);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return this.retrieveResponse(title, description, uri, responseCode, accept, headerFields, request);
    }

    private ResponseEntity retrieveResponseFromRequest(String title, String description, String method, String uri, String payload, MediaType payloadType, int responseCode, MediaType accept, List<String> headerFields) {
        ClientRequest request;
        try {
            request = payload != null ? ((ClientRequest.Builder)((ClientRequest.Builder)((ClientRequest.Builder)this.withHeaders(REQUEST_BUILDER).type(payloadType)).accept(new MediaType[]{accept})).entity((Object)payload)).build(new URI(uri), method) : ((ClientRequest.Builder)this.withHeaders(REQUEST_BUILDER).accept(new MediaType[]{accept})).build(new URI(uri), method);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return this.retrieveResponse(title, description, uri, responseCode, accept, headerFields, request);
    }

    private <T extends ClientRequest.Builder> T withHeaders(T builder) {
        for (Map.Entry<String, String> entry : this.addedRequestHeaders.entrySet()) {
            builder.header(entry.getKey(), (Object)entry.getValue());
        }
        return builder;
    }

    private ResponseEntity retrieveResponse(String title, String description, String uri, int responseCode, MediaType type, List<String> headerFields, ClientRequest request) {
        Client client;
        ClientResponse response;
        DocumentationData data = new DocumentationData();
        this.getRequestHeaders(data, (MultivaluedMap<String, Object>)request.getHeaders());
        if (request.getEntity() != null) {
            data.setPayload(String.valueOf(request.getEntity()));
            List contentTypes = (List)request.getHeaders().get((Object)"Content-Type");
            if (contentTypes != null) {
                if (contentTypes.size() != 1) {
                    throw new IllegalArgumentException("Request contains multiple content-types.");
                }
                Object contentType = contentTypes.get(0);
                if (contentType instanceof MediaType) {
                    data.setPayloadType((MediaType)contentType);
                }
            }
        }
        if ((response = (client = new Client()).handle(request)).hasEntity() && response.getStatus() != 204) {
            data.setEntity((String)response.getEntity(String.class));
        }
        if (response.getType() != null) {
            Assert.assertTrue((String)("wrong response type: " + data.entity), (boolean)response.getType().isCompatible(type));
        }
        for (String headerField : headerFields) {
            Assert.assertNotNull((String)("wrong headers: " + data.entity), (Object)response.getHeaders().get((Object)headerField));
        }
        if (this.noDoc) {
            data.setIgnore();
        }
        data.setTitle(title);
        data.setDescription(description);
        data.setMethod(request.getMethod());
        data.setUri(uri);
        data.setStatus(responseCode);
        Assert.assertEquals((String)("Wrong response status. response: " + data.entity), (long)responseCode, (long)response.getStatus());
        this.getResponseHeaders(data, (MultivaluedMap<String, String>)response.getHeaders(), headerFields);
        this.document(data);
        return new ResponseEntity(response, data.entity);
    }

    private void getResponseHeaders(DocumentationData data, MultivaluedMap<String, String> headers, List<String> additionalFilter) {
        data.setResponseHeaders(this.getHeaders(headers, RESPONSE_HEADERS, additionalFilter));
    }

    private void getRequestHeaders(DocumentationData data, MultivaluedMap<String, Object> headers) {
        data.setRequestHeaders(this.getHeaders(headers, REQUEST_HEADERS, this.addedRequestHeaders.keySet()));
    }

    private <T> Map<String, String> getHeaders(MultivaluedMap<String, T> headers, List<String> filter, Collection<String> additionalFilter) {
        TreeMap<String, String> filteredHeaders = new TreeMap<String, String>();
        for (Map.Entry header : headers.entrySet()) {
            String key = (String)header.getKey();
            if (!filter.contains(key) && !additionalFilter.contains(key)) continue;
            String values = "";
            for (Object value : (List)header.getValue()) {
                if (!values.isEmpty()) {
                    values = values + ", ";
                }
                values = values + String.valueOf(value);
            }
            filteredHeaders.put(key, values);
        }
        return filteredHeaders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void document(DocumentationData data) {
        if (data.ignore) {
            return;
        }
        Writer fw = null;
        try {
            String prettifiedPayload;
            String name = data.title.replace(" ", "-").toLowerCase();
            String filename = name + ".asciidoc";
            File dir = new File(new File(new File("target"), "docs"), this.section);
            data.description = this.replaceSnippets(data.description, dir, name);
            fw = AsciiDocGenerator.getFW((File)dir, (String)filename);
            String longSection = this.section.replaceAll("\\(|\\)", "") + "-" + name.replaceAll("\\(|\\)", "");
            if (longSection.indexOf("/") > 0) {
                longSection = longSection.substring(longSection.indexOf("/") + 1);
            }
            this.line(fw, "[[" + longSection + "]]");
            String firstChar = data.title.substring(0, 1).toUpperCase();
            String heading = firstChar + data.title.substring(1);
            this.line(fw, this.getAsciidocHeading(heading));
            this.line(fw, "");
            if (data.description != null && !data.description.isEmpty()) {
                this.line(fw, data.description);
                this.line(fw, "");
            }
            if (this.graph != null) {
                fw.append(AsciiDocGenerator.dumpToSeparateFile((File)dir, (String)(name + ".graph"), (String)AsciidocHelper.createGraphVizWithNodeId((String)"Final Graph", (GraphDatabaseService)this.graph, (String)this.title)));
                this.line(fw, "");
            }
            this.line(fw, "_Example request_");
            this.line(fw, "");
            StringBuilder sb = new StringBuilder(512);
            sb.append("* *+").append(data.method).append("+*  +").append(data.uri).append("+\n");
            if (data.requestHeaders != null) {
                for (Map.Entry<String, String> header : data.requestHeaders.entrySet()) {
                    sb.append("* *+").append(header.getKey()).append(":+* +").append(header.getValue()).append("+\n");
                }
            }
            if ((prettifiedPayload = data.getPayload()) != null) {
                this.writeEntity(sb, prettifiedPayload);
            }
            fw.append(AsciiDocGenerator.dumpToSeparateFile((File)dir, (String)(name + ".request"), (String)sb.toString()));
            sb = new StringBuilder(2048);
            this.line(fw, "");
            this.line(fw, "_Example response_");
            this.line(fw, "");
            sb.append("* *+").append(data.status).append(":+* +").append(Response.Status.fromStatusCode((int)data.status)).append("+\n");
            if (data.responseHeaders != null) {
                for (Map.Entry<String, String> header : data.responseHeaders.entrySet()) {
                    sb.append("* *+").append(header.getKey()).append(":+* +").append(header.getValue()).append("+\n");
                }
            }
            this.writeEntity(sb, data.getPrettifiedEntity());
            fw.append(AsciiDocGenerator.dumpToSeparateFile((File)dir, (String)(name + ".response"), (String)sb.toString()));
            this.line(fw, "");
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Assert.fail();
                }
            }
        }
    }

    private String getAsciidocHeading(String heading) {
        String equalSigns = EQUAL_SIGNS.substring(0, this.headingLevel);
        return equalSigns + ' ' + heading + ' ' + equalSigns;
    }

    public void writeEntity(StringBuilder sb, String entity) throws IOException {
        if (entity != null) {
            sb.append("\n[source,javascript]\n").append("----\n").append(entity).append("\n----\n\n");
        }
    }

    public static class ResponseEntity {
        private final String entity;
        private final JaxRsResponse response;

        public ResponseEntity(ClientResponse response, String entity) {
            this.response = new JaxRsResponse(response, entity);
            this.entity = entity;
        }

        public String entity() {
            return this.entity;
        }

        public JaxRsResponse response() {
            return this.response;
        }
    }
}

