/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.api.core.HttpRequestContext;
import java.net.URI;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.server.rest.repr.ExtensionInjector;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.OutputFormatProvider;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.RepresentationFormatRepository;

public class OutputFormatProviderTest {
    @Test
    public void shouldUseXForwardedHostHeaderWhenPresent() throws Exception {
        OutputFormatProvider provider = new OutputFormatProvider(new RepresentationFormatRepository(null));
        HttpRequestContext httpRequestContext = (HttpRequestContext)Mockito.mock(HttpRequestContext.class);
        HttpContext httpContext = (HttpContext)Mockito.mock(HttpContext.class);
        Mockito.when((Object)httpContext.getRequest()).thenReturn((Object)httpRequestContext);
        Mockito.when((Object)httpRequestContext.getBaseUri()).thenReturn((Object)new URI("http://localhost:37465"));
        Mockito.when((Object)httpRequestContext.getHeaderValue("X-Forwarded-Host")).thenReturn((Object)"foobar.com:9999");
        Representation representation = (Representation)Mockito.mock(Representation.class);
        OutputFormat outputFormat = provider.getValue(httpContext);
        outputFormat.format(representation);
        ((Representation)Mockito.verify((Object)representation)).serialize((RepresentationFormat)Matchers.any(RepresentationFormat.class), (URI)Matchers.eq((Object)new URI("http://foobar.com:9999")), (ExtensionInjector)Matchers.any(ExtensionInjector.class));
    }

    @Test
    public void shouldUseXForwardedProtoHeaderWhenPresent() throws Exception {
        OutputFormatProvider provider = new OutputFormatProvider(new RepresentationFormatRepository(null));
        HttpRequestContext httpRequestContext = (HttpRequestContext)Mockito.mock(HttpRequestContext.class);
        HttpContext httpContext = (HttpContext)Mockito.mock(HttpContext.class);
        Mockito.when((Object)httpContext.getRequest()).thenReturn((Object)httpRequestContext);
        Mockito.when((Object)httpRequestContext.getBaseUri()).thenReturn((Object)new URI("https://localhost:37465"));
        Mockito.when((Object)httpRequestContext.getHeaderValue("X-Forwarded-Proto")).thenReturn((Object)"http");
        Representation representation = (Representation)Mockito.mock(Representation.class);
        OutputFormat outputFormat = provider.getValue(httpContext);
        outputFormat.format(representation);
        ((Representation)Mockito.verify((Object)representation)).serialize((RepresentationFormat)Matchers.any(RepresentationFormat.class), (URI)Matchers.eq((Object)new URI("http://localhost:37465")), (ExtensionInjector)Matchers.any(ExtensionInjector.class));
    }

    @Test
    public void shouldPickFirstXForwardedHostHeaderValueFromCommaAndSpaceSeparatedList() throws Exception {
        OutputFormatProvider provider = new OutputFormatProvider(new RepresentationFormatRepository(null));
        HttpRequestContext httpRequestContext = (HttpRequestContext)Mockito.mock(HttpRequestContext.class);
        HttpContext httpContext = (HttpContext)Mockito.mock(HttpContext.class);
        Mockito.when((Object)httpContext.getRequest()).thenReturn((Object)httpRequestContext);
        Mockito.when((Object)httpRequestContext.getBaseUri()).thenReturn((Object)new URI("http://localhost:37465"));
        Mockito.when((Object)httpRequestContext.getHeaderValue("X-Forwarded-Host")).thenReturn((Object)"foobar.com:9999, bazbar.org:8888, barbar.me:7777");
        Representation representation = (Representation)Mockito.mock(Representation.class);
        OutputFormat outputFormat = provider.getValue(httpContext);
        outputFormat.format(representation);
        ((Representation)Mockito.verify((Object)representation)).serialize((RepresentationFormat)Matchers.any(RepresentationFormat.class), (URI)Matchers.eq((Object)new URI("http://foobar.com:9999")), (ExtensionInjector)Matchers.any(ExtensionInjector.class));
    }

    @Test
    public void shouldPickFirstXForwardedHostHeaderValueFromCommaSeparatedList() throws Exception {
        OutputFormatProvider provider = new OutputFormatProvider(new RepresentationFormatRepository(null));
        HttpRequestContext httpRequestContext = (HttpRequestContext)Mockito.mock(HttpRequestContext.class);
        HttpContext httpContext = (HttpContext)Mockito.mock(HttpContext.class);
        Mockito.when((Object)httpContext.getRequest()).thenReturn((Object)httpRequestContext);
        Mockito.when((Object)httpRequestContext.getBaseUri()).thenReturn((Object)new URI("http://localhost:37465"));
        Mockito.when((Object)httpRequestContext.getHeaderValue("X-Forwarded-Host")).thenReturn((Object)"foobar.com:9999,bazbar.org:8888,barbar.me:7777");
        Representation representation = (Representation)Mockito.mock(Representation.class);
        OutputFormat outputFormat = provider.getValue(httpContext);
        outputFormat.format(representation);
        ((Representation)Mockito.verify((Object)representation)).serialize((RepresentationFormat)Matchers.any(RepresentationFormat.class), (URI)Matchers.eq((Object)new URI("http://foobar.com:9999")), (ExtensionInjector)Matchers.any(ExtensionInjector.class));
    }

    @Test
    public void shouldUseBaseUriOnBadXForwardedHostHeader() throws Exception {
        OutputFormatProvider provider = new OutputFormatProvider(new RepresentationFormatRepository(null));
        HttpRequestContext httpRequestContext = (HttpRequestContext)Mockito.mock(HttpRequestContext.class);
        HttpContext httpContext = (HttpContext)Mockito.mock(HttpContext.class);
        Mockito.when((Object)httpContext.getRequest()).thenReturn((Object)httpRequestContext);
        Mockito.when((Object)httpRequestContext.getBaseUri()).thenReturn((Object)new URI("http://localhost:37465"));
        Mockito.when((Object)httpRequestContext.getHeaderValue("X-Forwarded-Host")).thenReturn((Object)":5543:foobar.com:9999");
        Representation representation = (Representation)Mockito.mock(Representation.class);
        OutputFormat outputFormat = provider.getValue(httpContext);
        outputFormat.format(representation);
        ((Representation)Mockito.verify((Object)representation)).serialize((RepresentationFormat)Matchers.any(RepresentationFormat.class), (URI)Matchers.eq((Object)new URI("http://localhost:37465")), (ExtensionInjector)Matchers.any(ExtensionInjector.class));
    }

    @Test
    public void shouldUseBaseUriIfFirstAddressInXForwardedHostHeaderIsBad() throws Exception {
        OutputFormatProvider provider = new OutputFormatProvider(new RepresentationFormatRepository(null));
        HttpRequestContext httpRequestContext = (HttpRequestContext)Mockito.mock(HttpRequestContext.class);
        HttpContext httpContext = (HttpContext)Mockito.mock(HttpContext.class);
        Mockito.when((Object)httpContext.getRequest()).thenReturn((Object)httpRequestContext);
        Mockito.when((Object)httpRequestContext.getBaseUri()).thenReturn((Object)new URI("http://localhost:37465"));
        Mockito.when((Object)httpRequestContext.getHeaderValue("X-Forwarded-Host")).thenReturn((Object)":5543:foobar.com:9999, bazbar.com:8888");
        Representation representation = (Representation)Mockito.mock(Representation.class);
        OutputFormat outputFormat = provider.getValue(httpContext);
        outputFormat.format(representation);
        ((Representation)Mockito.verify((Object)representation)).serialize((RepresentationFormat)Matchers.any(RepresentationFormat.class), (URI)Matchers.eq((Object)new URI("http://localhost:37465")), (ExtensionInjector)Matchers.any(ExtensionInjector.class));
    }

    @Test
    public void shouldUseBaseUriOnBadXForwardedProtoHeader() throws Exception {
        OutputFormatProvider provider = new OutputFormatProvider(new RepresentationFormatRepository(null));
        HttpRequestContext httpRequestContext = (HttpRequestContext)Mockito.mock(HttpRequestContext.class);
        HttpContext httpContext = (HttpContext)Mockito.mock(HttpContext.class);
        Mockito.when((Object)httpContext.getRequest()).thenReturn((Object)httpRequestContext);
        Mockito.when((Object)httpRequestContext.getBaseUri()).thenReturn((Object)new URI("http://localhost:37465"));
        Mockito.when((Object)httpRequestContext.getHeaderValue("X-Forwarded-Proto")).thenReturn((Object)"%%%DEFINITELY-NOT-A-PROTO!");
        Representation representation = (Representation)Mockito.mock(Representation.class);
        OutputFormat outputFormat = provider.getValue(httpContext);
        outputFormat.format(representation);
        ((Representation)Mockito.verify((Object)representation)).serialize((RepresentationFormat)Matchers.any(RepresentationFormat.class), (URI)Matchers.eq((Object)new URI("http://localhost:37465")), (ExtensionInjector)Matchers.any(ExtensionInjector.class));
    }

    @Test
    public void shouldUseXForwardedHostAndXForwardedProtoHeadersWhenPresent() throws Exception {
        OutputFormatProvider provider = new OutputFormatProvider(new RepresentationFormatRepository(null));
        HttpRequestContext httpRequestContext = (HttpRequestContext)Mockito.mock(HttpRequestContext.class);
        HttpContext httpContext = (HttpContext)Mockito.mock(HttpContext.class);
        Mockito.when((Object)httpContext.getRequest()).thenReturn((Object)httpRequestContext);
        Mockito.when((Object)httpRequestContext.getBaseUri()).thenReturn((Object)new URI("http://localhost:37465"));
        Mockito.when((Object)httpRequestContext.getHeaderValue("X-Forwarded-Host")).thenReturn((Object)"foobar.com:9999");
        Mockito.when((Object)httpRequestContext.getHeaderValue("X-Forwarded-Proto")).thenReturn((Object)"https");
        Representation representation = (Representation)Mockito.mock(Representation.class);
        OutputFormat outputFormat = provider.getValue(httpContext);
        outputFormat.format(representation);
        ((Representation)Mockito.verify((Object)representation)).serialize((RepresentationFormat)Matchers.any(RepresentationFormat.class), (URI)Matchers.eq((Object)new URI("https://foobar.com:9999")), (ExtensionInjector)Matchers.any(ExtensionInjector.class));
    }
}

