/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.startup.healthcheck;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.server.startup.healthcheck.HTTPLoggingPreparednessRule;
import org.neo4j.test.TargetDirectory;

public class HTTPLoggingPreparednessRuleTest {
    @Test
    public void shouldPassWhenExplicitlyDisabled() {
        HTTPLoggingPreparednessRule rule = new HTTPLoggingPreparednessRule();
        Properties properties = new Properties();
        properties.put("org.neo4j.server.http.log.enabled", "false");
        boolean result = rule.execute(properties);
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((Object)"", (Object)rule.getFailureMessage());
    }

    @Test
    public void shouldPassWhenImplicitlyDisabled() {
        HTTPLoggingPreparednessRule rule = new HTTPLoggingPreparednessRule();
        Properties properties = new Properties();
        boolean result = rule.execute(properties);
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((Object)"", (Object)rule.getFailureMessage());
    }

    @Test
    public void shouldPassWhenEnabledWithGoodConfigSpecified() throws Exception {
        File logDir = TargetDirectory.forTest(this.getClass()).directory("logDir");
        File confDir = TargetDirectory.forTest(this.getClass()).directory("confDir");
        HTTPLoggingPreparednessRule rule = new HTTPLoggingPreparednessRule();
        Properties properties = new Properties();
        properties.put("org.neo4j.server.http.log.enabled", "true");
        properties.put("org.neo4j.server.http.log.config", HTTPLoggingPreparednessRuleTest.createConfigFile(HTTPLoggingPreparednessRuleTest.createLogbackConfigXml(logDir), confDir).getAbsolutePath());
        boolean result = rule.execute(properties);
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((Object)"", (Object)rule.getFailureMessage());
    }

    @Test
    public void shouldFailWhenEnabledWithUnwritableLogDirSpecifiedInConfig() throws Exception {
        File confDir = TargetDirectory.forTest(this.getClass()).directory("confDir");
        HTTPLoggingPreparednessRule rule = new HTTPLoggingPreparednessRule();
        Properties properties = new Properties();
        properties.put("org.neo4j.server.http.log.enabled", "true");
        File unwritableDirectory = HTTPLoggingPreparednessRuleTest.createUnwritableDirectory();
        properties.put("org.neo4j.server.http.log.config", HTTPLoggingPreparednessRuleTest.createConfigFile(HTTPLoggingPreparednessRuleTest.createLogbackConfigXml(unwritableDirectory), confDir).getAbsolutePath());
        boolean result = rule.execute(properties);
        Assert.assertFalse((boolean)result);
        Assert.assertEquals((Object)String.format("HTTP log directory [%s] does not exist", unwritableDirectory), (Object)rule.getFailureMessage());
    }

    public static File createUnwritableDirectory() {
        File file = GraphDatabaseSetting.osIsWindows() ? new File("\\\\" + UUID.randomUUID().toString() + "\\") : (GraphDatabaseSetting.osIsMacOS() ? new File("/Network/Servers/localhost/" + UUID.randomUUID().toString()) : new File("/proc/" + UUID.randomUUID().toString() + "/random"));
        return file;
    }

    public static File createConfigFile(String configXml, File location) throws IOException {
        File configFile = new File(location.getAbsolutePath() + File.separator + "neo4j-logback-config.xml");
        FileOutputStream fos = new FileOutputStream(configFile);
        fos.write(configXml.getBytes());
        fos.close();
        return configFile;
    }

    public static String createLogbackConfigXml(File logDirectory) {
        return "<configuration>\n  <appender name=\"FILE\" class=\"ch.qos.logback.core.rolling.RollingFileAppender\">\n    <file>" + logDirectory.getAbsolutePath() + File.separator + "http.log</file>\n" + "    <rollingPolicy class=\"ch.qos.logback.core.rolling.TimeBasedRollingPolicy\">\n" + "      <fileNamePattern>" + logDirectory.getAbsolutePath() + File.separator + "http.%d{yyyy-MM-dd_HH}.log</fileNamePattern>\n" + "      <maxHistory>30</maxHistory>\n" + "    </rollingPolicy>\n" + "\n" + "    <encoder>\n" + "      <!-- Note the deliberate misspelling of \"referer\" in accordance with RFC1616 -->\n" + "      <pattern>%h %l %user [%t{dd/MMM/yyyy:HH:mm:ss Z}] \"%r\" %s %b \"%i{Referer}\" \"%i{User-Agent}\"</pattern>\n" + "    </encoder>\n" + "  </appender>\n" + "\n" + "  <appender-ref ref=\"FILE\" />\n" + "</configuration>";
    }
}

