/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.webadmin.console;

import org.neo4j.cypher.SyntaxException;
import org.neo4j.cypher.javacompat.ExecutionResult;
import org.neo4j.helpers.Pair;
import org.neo4j.server.database.CypherExecutor;
import org.neo4j.server.logging.Logger;
import org.neo4j.server.webadmin.console.ScriptSession;

public class CypherSession
implements ScriptSession {
    private final CypherExecutor cypherExecutor;
    private static Logger log = Logger.getLogger(CypherSession.class);

    public CypherSession(CypherExecutor cypherExecutor) {
        this.cypherExecutor = cypherExecutor;
    }

    @Override
    public Pair<String, String> evaluate(String script) {
        String resultString;
        if (script.trim().equals("")) {
            return Pair.of((Object)"", null);
        }
        try {
            ExecutionResult result = this.cypherExecutor.getExecutionEngine().execute(script);
            resultString = result.toString();
        }
        catch (SyntaxException error) {
            resultString = error.getMessage();
        }
        catch (Exception exception) {
            log.error(exception);
            resultString = "Error: " + exception.getClass().getSimpleName() + " - " + exception.getMessage();
        }
        return Pair.of((Object)resultString, null);
    }
}

