/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import com.sun.jersey.api.client.ClientResponse;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.server.database.DatabaseBlockedException;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.RESTDocsGenerator;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.test.GraphDescription;
import org.neo4j.test.TestData;

public class RelationshipFunctionalTest
extends AbstractRestFunctionalTestBase {
    @Test
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="Romeo", setNameProperty=true), @GraphDescription.NODE(name="Juliet", setNameProperty=true)}, relationships={@GraphDescription.REL(start="Romeo", end="Juliet", type="LOVES", properties={@GraphDescription.PROP(key="cost", value="high", type=GraphDescription.PropType.STRING)})})
    @TestData.Title(value="Remove properties from a relationship")
    public void shouldReturn204WhenPropertiesAreRemovedFromRelationship() throws DatabaseBlockedException {
        Relationship loves = (Relationship)this.getNode("Romeo").getRelationships().iterator().next();
        ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(Response.Status.NO_CONTENT.getStatusCode()).delete(this.getRelationshipUri(loves)).entity();
    }

    @Test
    @GraphDescription.Graph(value={"I know you"})
    public void get_Relationship_by_ID() throws JsonParseException {
        String response = ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(ClientResponse.Status.OK.getStatusCode()).get(this.getRelationshipUri(((Node)((Map)this.data.get()).get("I")).getSingleRelationship((RelationshipType)DynamicRelationshipType.withName((String)"know"), Direction.OUTGOING))).entity();
        Assert.assertTrue((boolean)JsonHelper.jsonToMap((String)response).containsKey("start"));
    }

    @Test
    @Documented(value=" See the example request below.\n")
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="Romeo", setNameProperty=true), @GraphDescription.NODE(name="Juliet", setNameProperty=true)}, relationships={@GraphDescription.REL(start="Romeo", end="Juliet", type="LOVES", properties={@GraphDescription.PROP(key="cost", value="high", type=GraphDescription.PropType.STRING)})})
    @TestData.Title(value="Remove property from a relationship")
    public void shouldReturn204WhenPropertyIsRemovedFromRelationship() throws DatabaseBlockedException {
        this.data.get();
        Relationship loves = (Relationship)this.getNode("Romeo").getRelationships().iterator().next();
        ((RESTDocsGenerator)((Object)this.gen.get())).description(this.startGraph("Remove property from a relationship1"));
        ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(Response.Status.NO_CONTENT.getStatusCode()).delete(this.getPropertiesUri(loves) + "/cost").entity();
    }

    @Test
    @Documented(value=" Attempting to remove a property that doesn't exist results in\n an error.\n")
    @TestData.Title(value="Remove non-existent property from a relationship")
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="Romeo", setNameProperty=true), @GraphDescription.NODE(name="Juliet", setNameProperty=true)}, relationships={@GraphDescription.REL(start="Romeo", end="Juliet", type="LOVES", properties={@GraphDescription.PROP(key="cost", value="high", type=GraphDescription.PropType.STRING)})})
    public void shouldReturn404WhenPropertyWhichDoesNotExistRemovedFromRelationship() {
        this.data.get();
        Relationship loves = (Relationship)this.getNode("Romeo").getRelationships().iterator().next();
        ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(Response.Status.NOT_FOUND.getStatusCode()).delete(this.getPropertiesUri(loves) + "/non-existent").entity();
    }

    @Test
    @GraphDescription.Graph(value={"I know you"})
    @Documented(value=" Attempting to remove all properties from a relationship which doesn't\n exist results in an error.\n")
    @TestData.Title(value="Remove properties from a non-existing relationship")
    public void shouldReturn404WhenPropertiesRemovedFromARelationshipWhichDoesNotExist() {
        this.data.get();
        ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(Response.Status.NOT_FOUND.getStatusCode()).delete("http://localhost:7474/db/data/relationship/1234/properties").entity();
    }

    @Test
    @GraphDescription.Graph(value={"I know you"})
    @Documented(value=" Attempting to remove a property from a relationship which doesn't exist\n results in an error.\n")
    @TestData.Title(value="Remove property from a non-existing relationship")
    public void shouldReturn404WhenPropertyRemovedFromARelationshipWhichDoesNotExist() {
        this.data.get();
        ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(Response.Status.NOT_FOUND.getStatusCode()).delete("http://localhost:7474/db/data/relationship/1234/properties/cost").entity();
    }

    @Test
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="Romeo", setNameProperty=true), @GraphDescription.NODE(name="Juliet", setNameProperty=true)}, relationships={@GraphDescription.REL(start="Romeo", end="Juliet", type="LOVES", properties={@GraphDescription.PROP(key="cost", value="high", type=GraphDescription.PropType.STRING)})})
    @TestData.Title(value="Delete relationship")
    public void removeRelationship() {
        this.data.get();
        Relationship loves = (Relationship)this.getNode("Romeo").getRelationships().iterator().next();
        ((RESTDocsGenerator)((Object)this.gen.get())).description(this.startGraph("Delete relationship1"));
        ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(Response.Status.NO_CONTENT.getStatusCode()).delete(this.getRelationshipUri(loves)).entity();
    }

    @Test
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="Romeo", setNameProperty=true), @GraphDescription.NODE(name="Juliet", setNameProperty=true)}, relationships={@GraphDescription.REL(start="Romeo", end="Juliet", type="LOVES", properties={@GraphDescription.PROP(key="cost", value="high", type=GraphDescription.PropType.STRING)})})
    public void get_single_property_on_a_relationship() throws Exception {
        Relationship loves = (Relationship)this.getNode("Romeo").getRelationships().iterator().next();
        String response = this.gen().expectedStatus(ClientResponse.Status.OK).get(this.getRelPropURI(loves, "cost")).entity();
        Assert.assertTrue((boolean)response.contains("high"));
    }

    private String getRelPropURI(Relationship loves, String propertyKey) {
        return this.getRelationshipUri(loves) + "/properties/" + propertyKey;
    }

    @Test
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="Romeo", setNameProperty=true), @GraphDescription.NODE(name="Juliet", setNameProperty=true)}, relationships={@GraphDescription.REL(start="Romeo", end="Juliet", type="LOVES", properties={@GraphDescription.PROP(key="cost", value="high", type=GraphDescription.PropType.STRING)})})
    public void set_single_property_on_a_relationship() throws Exception {
        Relationship loves = (Relationship)this.getNode("Romeo").getRelationships().iterator().next();
        Assert.assertTrue((boolean)loves.getProperty("cost").equals("high"));
        this.gen().description(this.startGraph("Set relationship property1"));
        this.gen().expectedStatus(ClientResponse.Status.NO_CONTENT).payload("\"deadly\"").put(this.getRelPropURI(loves, "cost")).entity();
        Assert.assertTrue((boolean)loves.getProperty("cost").equals("deadly"));
    }

    @Test
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="Romeo", setNameProperty=true), @GraphDescription.NODE(name="Juliet", setNameProperty=true)}, relationships={@GraphDescription.REL(start="Romeo", end="Juliet", type="LOVES", properties={@GraphDescription.PROP(key="cost", value="high", type=GraphDescription.PropType.STRING), @GraphDescription.PROP(key="since", value="1day", type=GraphDescription.PropType.STRING)})})
    public void set_all_properties_on_a_relationship() throws Exception {
        Relationship loves = (Relationship)this.getNode("Romeo").getRelationships().iterator().next();
        Assert.assertTrue((boolean)loves.getProperty("cost").equals("high"));
        this.gen().description(this.startGraph("Set relationship property1"));
        this.gen().expectedStatus(ClientResponse.Status.NO_CONTENT).payload(JsonHelper.createJsonFrom((Object)MapUtil.map((Object[])new Object[]{"happy", false}))).put(this.getRelPropsURI(loves)).entity();
        Assert.assertTrue(((Boolean)loves.getProperty("happy") == false ? 1 : 0) != 0);
        Assert.assertFalse((boolean)loves.hasProperty("cost"));
    }

    @Test
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="Romeo", setNameProperty=true), @GraphDescription.NODE(name="Juliet", setNameProperty=true)}, relationships={@GraphDescription.REL(start="Romeo", end="Juliet", type="LOVES", properties={@GraphDescription.PROP(key="cost", value="high", type=GraphDescription.PropType.STRING), @GraphDescription.PROP(key="since", value="1day", type=GraphDescription.PropType.STRING)})})
    public void get_all_properties_on_a_relationship() throws Exception {
        Relationship loves = (Relationship)this.getNode("Romeo").getRelationships().iterator().next();
        String response = this.gen().expectedStatus(ClientResponse.Status.OK).get(this.getRelPropsURI(loves)).entity();
        Assert.assertTrue((boolean)response.contains("high"));
    }

    private String getRelPropsURI(Relationship rel) {
        return this.getRelationshipUri(rel) + "/properties";
    }
}

