/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rrd;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.server.database.Database;
import org.neo4j.server.rrd.sampler.NodeIdsInUseSampleable;
import org.neo4j.test.ImpermanentGraphDatabase;

public class NodeIdsInUseSampleableTest {
    public Database db;
    public NodeIdsInUseSampleable sampleable;

    @Test
    public void emptyDbHasZeroNodesInUse() {
        MatcherAssert.assertThat((Object)this.sampleable.getValue(), (Matcher)Is.is((Object)1.0));
    }

    @Test
    public void addANodeAndSampleableGoesUp() {
        double oldValue = this.sampleable.getValue();
        this.createNode(this.db.graph);
        MatcherAssert.assertThat((Object)this.sampleable.getValue(), (Matcher)Matchers.greaterThan((Comparable)Double.valueOf(oldValue)));
    }

    private void createNode(GraphDatabaseAPI db) {
        Transaction tx = db.beginTx();
        db.createNode();
        tx.success();
        tx.finish();
    }

    @Before
    public void setUp() throws Exception {
        this.db = new Database((GraphDatabaseAPI)new ImpermanentGraphDatabase());
        this.sampleable = new NodeIdsInUseSampleable(this.db.graph);
    }

    @After
    public void shutdown() {
        this.db.shutdown();
    }
}

