/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.server.WrappingNeoServerBootstrapper;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.configuration.ServerConfigurator;
import org.neo4j.test.ImpermanentGraphDatabase;

@Ignore(value="This feature has to be done some other way")
public class ExecutionTimeLimitTest {
    private WrappingNeoServerBootstrapper testBootstrapper;
    private AbstractGraphDatabase db;
    private long wait;

    @Test(expected=UniformInterfaceException.class)
    public void expectLimitation() {
        this.wait = 2000L;
        Client.create().resource("http://localhost:7476/db/data/node/0").header("accept", (Object)"application/json").get(String.class);
    }

    @Test(expected=UniformInterfaceException.class)
    public void expectLimitationByHeader() {
        this.wait = 200L;
        ((WebResource.Builder)Client.create().resource("http://localhost:7476/db/data/node/0").header("accept", (Object)"application/json").header("max-execution-time", (Object)"100")).get(String.class);
    }

    @Test
    public void expectNoLimitation() {
        this.wait = 200L;
        Client.create().resource("http://localhost:7476/db/data/node/0").header("accept", (Object)"application/json").get(String.class);
    }

    @Before
    public void setUp() throws Exception {
        this.db = new ImpermanentGraphDatabase(){

            public Node getNodeById(long id) {
                try {
                    Thread.sleep(ExecutionTimeLimitTest.this.wait);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                return super.getNodeById(id);
            }
        };
        ServerConfigurator config = new ServerConfigurator((GraphDatabaseAPI)this.db);
        config.configuration().setProperty("org.neo4j.server.webserver.port", (Object)7476);
        config.configuration().setProperty("org.neo4j.server.webserver.limit.executiontime", (Object)1000);
        this.testBootstrapper = new WrappingNeoServerBootstrapper((GraphDatabaseAPI)this.db, (Configurator)config);
        this.testBootstrapper.start();
    }

    @After
    public void tearDown() {
        this.testBootstrapper.stop();
        this.db.shutdown();
    }
}

