/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.webadmin.rest;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.List;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.server.database.Database;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.server.rest.repr.InputFormat;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.formats.JsonFormat;
import org.neo4j.server.webadmin.console.ScriptSession;
import org.neo4j.server.webadmin.rest.ConsoleService;
import org.neo4j.server.webadmin.rest.SessionFactory;
import org.neo4j.server.webadmin.rest.ShellSession;
import org.neo4j.shell.ShellSettings;
import org.neo4j.test.TestGraphDatabaseFactory;

public class Neo4jShellConsoleSessionTest
implements SessionFactory {
    private static final String LN = System.getProperty("line.separator");
    private ConsoleService consoleService;
    private Database database;
    private final URI uri = URI.create("http://peteriscool.com:6666/");

    @Before
    public void setUp() throws Exception {
        this.database = new Database((GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder().setConfig((GraphDatabaseSetting)ShellSettings.remote_shell_enabled, "true").newGraphDatabase());
        this.consoleService = new ConsoleService((SessionFactory)this, this.database, new OutputFormat((RepresentationFormat)new JsonFormat(), this.uri, null));
    }

    @After
    public void shutdownDatabase() {
        this.database.shutdown();
    }

    public ScriptSession createSession(String engineName, Database database) {
        return new ShellSession(database.graph);
    }

    @Test
    public void doesntMangleNewlines() throws Exception {
        Response response = this.consoleService.exec((InputFormat)new JsonFormat(), "{ \"command\" : \"start n=node(0) return n;\", \"engine\":\"shell\" }");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        String result = this.decode(response).get(0);
        String expected = "+-----------+" + LN + "| n         |" + LN + "+-----------+" + LN + "| Node[0]{} |" + LN + "+-----------+" + LN + "1 row";
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.containsString((String)expected));
    }

    private List<String> decode(Response response) throws UnsupportedEncodingException, JsonParseException {
        return (List)JsonHelper.readJson((String)new String((byte[])response.getEntity(), "UTF-8"));
    }
}

