/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriInfo;
import org.mortbay.log.Log;
import org.neo4j.graphdb.Transaction;
import org.neo4j.server.database.Database;
import org.neo4j.server.rest.batch.BatchOperationResults;
import org.neo4j.server.rest.batch.NonStreamingBatchOperations;
import org.neo4j.server.rest.repr.BadInputException;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.web.StreamingBatchOperations;
import org.neo4j.server.web.WebServer;

@Path(value="/batch")
public class BatchOperationService {
    private final OutputFormat output;
    private final WebServer webServer;
    private final Database database;

    public BatchOperationService(@Context Database database, @Context WebServer webServer, @Context OutputFormat output) {
        this.output = output;
        this.webServer = webServer;
        this.database = database;
    }

    @POST
    public Response performBatchOperations(@Context UriInfo uriInfo, @Context HttpHeaders httpHeaders, InputStream body) throws BadInputException {
        if (this.isStreaming(httpHeaders)) {
            return this.batchProcessAndStream(uriInfo, httpHeaders, body);
        }
        return this.batchProcess(uriInfo, httpHeaders, body);
    }

    private Response batchProcessAndStream(final UriInfo uriInfo, final HttpHeaders httpHeaders, final InputStream body) {
        try {
            StreamingOutput stream = new StreamingOutput(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void write(final OutputStream output) throws IOException, WebApplicationException {
                    Transaction tx = ((BatchOperationService)BatchOperationService.this).database.graph.beginTx();
                    try {
                        ServletOutputStream servletOutputStream = new ServletOutputStream(){

                            public void write(int i) throws IOException {
                                output.write(i);
                            }
                        };
                        new StreamingBatchOperations(BatchOperationService.this.webServer).readAndExecuteOperations(uriInfo, httpHeaders, body, servletOutputStream);
                        tx.success();
                    }
                    catch (Exception e) {
                        Log.warn((String)"Error executing batch request ", (Throwable)e);
                        tx.failure();
                    }
                    finally {
                        tx.finish();
                    }
                }
            };
            return Response.ok((Object)stream).header("Content-Encoding", (Object)"UTF-8").type("application/json").build();
        }
        catch (Exception e) {
            return this.output.serverError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response batchProcess(UriInfo uriInfo, HttpHeaders httpHeaders, InputStream body) {
        Transaction tx = this.database.graph.beginTx();
        try {
            NonStreamingBatchOperations batchOperations = new NonStreamingBatchOperations(this.webServer);
            BatchOperationResults results = batchOperations.performBatchJobs(uriInfo, httpHeaders, body);
            Response res = Response.ok().entity((Object)results.toJSON()).header("Content-Encoding", (Object)"UTF-8").type("application/json").build();
            tx.success();
            Response response = res;
            return response;
        }
        catch (Exception e) {
            tx.failure();
            Response response = this.output.serverError(e);
            return response;
        }
        finally {
            tx.finish();
        }
    }

    private boolean isStreaming(HttpHeaders httpHeaders) {
        for (MediaType mediaType : httpHeaders.getAcceptableMediaTypes()) {
            Map parameters = mediaType.getParameters();
            if (!parameters.containsKey("stream") || !((String)parameters.get("stream")).equals("true")) continue;
            return true;
        }
        return false;
    }
}

