/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.startup.healthcheck;

import java.util.Properties;
import org.neo4j.server.logging.Logger;
import org.neo4j.server.startup.healthcheck.StartupHealthCheckRule;

public class StartupHealthCheck {
    public static final Logger log = Logger.getLogger(StartupHealthCheck.class);
    private final StartupHealthCheckRule[] rules;
    private StartupHealthCheckRule failedRule = null;
    private Properties properties;

    public StartupHealthCheck(Properties properties, StartupHealthCheckRule ... rules) {
        this.rules = rules;
        this.properties = properties;
    }

    public StartupHealthCheck(StartupHealthCheckRule ... rules) {
        this(System.getProperties(), rules);
    }

    public boolean run() {
        if (this.rules == null || this.rules.length < 1) {
            return true;
        }
        for (StartupHealthCheckRule r : this.rules) {
            if (r.execute(this.properties)) continue;
            log.error(r.getFailureMessage(), new Object[0]);
            this.failedRule = r;
            return false;
        }
        return true;
    }

    public StartupHealthCheckRule failedRule() {
        return this.failedRule;
    }
}

