/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.IOException;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.server.NeoServerWithEmbeddedWebServer;
import org.neo4j.server.configuration.PropertyFileConfigurator;
import org.neo4j.server.helpers.ServerBuilder;
import org.neo4j.server.logging.InMemoryAppender;
import org.neo4j.test.server.ExclusiveServerTestBase;

public class DatabaseTuningFunctionalTest
extends ExclusiveServerTestBase {
    @Ignore(value="Relies on internal config, which is bad")
    @Test
    public void shouldLoadAKnownGoodPropertyFile() throws IOException {
        NeoServerWithEmbeddedWebServer server = ServerBuilder.server().withDefaultDatabaseTuning().build();
        server.start();
        Map<Object, Object> params = null;
        Assert.assertTrue((boolean)this.propertyAndValuePresentIn("neostore.nodestore.db.mapped_memory", "25M", params));
        Assert.assertTrue((boolean)this.propertyAndValuePresentIn("neostore.relationshipstore.db.mapped_memory", "50M", params));
        Assert.assertTrue((boolean)this.propertyAndValuePresentIn("neostore.propertystore.db.mapped_memory", "90M", params));
        Assert.assertTrue((boolean)this.propertyAndValuePresentIn("neostore.propertystore.db.strings.mapped_memory", "130M", params));
        Assert.assertTrue((boolean)this.propertyAndValuePresentIn("neostore.propertystore.db.arrays.mapped_memory", "130M", params));
        server.stop();
    }

    private boolean propertyAndValuePresentIn(String name, String value, Map<Object, Object> params) {
        Object paramValue = params.get(name);
        return paramValue != null && paramValue.toString().equals(value);
    }

    @Test
    public void shouldLogWarningAndContinueIfTuningFilePropertyDoesNotResolve() throws IOException {
        InMemoryAppender appender = new InMemoryAppender(PropertyFileConfigurator.log);
        NeoServerWithEmbeddedWebServer server = ServerBuilder.server().withNonResolvableTuningFile().build();
        server.start();
        Assert.assertThat((Object)appender.toString(), (Matcher)Matchers.containsString((String)String.format("The specified file for database performance tuning properties [", new Object[0])));
        Assert.assertThat((Object)appender.toString(), (Matcher)Matchers.containsString((String)String.format("] does not exist.", new Object[0])));
        server.stop();
    }
}

