/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.modules;

import java.net.URI;
import java.util.List;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.server.NeoServerWithEmbeddedWebServer;
import org.neo4j.server.modules.ManagementApiModule;
import org.neo4j.server.web.WebServer;

public class ManagementApiModuleTest {
    @Test
    public void shouldRegisterASingleUri() throws Exception {
        WebServer webServer = (WebServer)Mockito.mock(WebServer.class);
        NeoServerWithEmbeddedWebServer neoServer = (NeoServerWithEmbeddedWebServer)Mockito.mock(NeoServerWithEmbeddedWebServer.class);
        Mockito.when((Object)neoServer.baseUri()).thenReturn((Object)new URI("http://localhost:7575"));
        Mockito.when((Object)neoServer.getWebServer()).thenReturn((Object)webServer);
        PropertiesConfiguration config = new PropertiesConfiguration();
        String managementPath = "/db/manage";
        config.addProperty("org.neo4j.server.webadmin.management.uri", (Object)managementPath);
        Mockito.when((Object)neoServer.getConfiguration()).thenReturn((Object)config);
        ManagementApiModule module = new ManagementApiModule();
        module.start(neoServer, null);
        ((WebServer)Mockito.verify((Object)webServer)).addJAXRSPackages((List)Matchers.any(List.class), Matchers.anyString());
    }
}

