/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.Version;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RESTDocsGenerator;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.test.GraphDescription;
import org.neo4j.test.TestData;

public class GetOnRootFunctionalTest
extends AbstractRestFunctionalTestBase {
    @Documented(value=" The service root is your starting point to discover the REST API.\n It contains the basic starting points for the databse, and some\n version and extension information. The +reference_node+ entry will\n only be present if there is a reference node set and exists in the database.\n")
    @Test
    @GraphDescription.Graph(value={"I know you"})
    @TestData.Title(value="Get service root")
    public void assert200OkFromGet() throws Exception {
        AbstractGraphDatabase db = (AbstractGraphDatabase)this.graphdb();
        Transaction tx = db.beginTx();
        long referenceNodeId = ((Node)((Map)this.data.get()).get("I")).getId();
        db.getNodeManager().setReferenceNodeId(referenceNodeId);
        tx.success();
        tx.finish();
        String body = ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(200).get(this.getDataUri()).entity();
        Map map = JsonHelper.jsonToMap((String)body);
        Assert.assertEquals((Object)(this.getDataUri() + "node"), map.get("node"));
        Assert.assertNotNull(map.get("reference_node"));
        Assert.assertNotNull(map.get("node_index"));
        Assert.assertNotNull(map.get("relationship_index"));
        Assert.assertNotNull(map.get("extensions_info"));
        Assert.assertNotNull(map.get("batch"));
        Assert.assertNotNull(map.get("cypher"));
        Assert.assertEquals((Object)Version.getKernelRevision(), map.get("neo4j_version"));
        JaxRsResponse response = RestRequest.req().get(this.getDataUri());
        if (map.get("reference_node") != null) {
            response = RestRequest.req().get((String)map.get("reference_node"));
            Assert.assertEquals((long)200L, (long)response.getStatus());
            response.close();
        }
        Assert.assertTrue(((response = RestRequest.req().get((String)map.get("node_index"))).getStatus() == 200 || response.getStatus() == 204 ? 1 : 0) != 0);
        response.close();
        response = RestRequest.req().get((String)map.get("relationship_index"));
        Assert.assertTrue((response.getStatus() == 200 || response.getStatus() == 204 ? 1 : 0) != 0);
        response.close();
        response = RestRequest.req().get((String)map.get("extensions_info"));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        response.close();
        response = RestRequest.req().post((String)map.get("batch"), "[]");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        response.close();
        response = RestRequest.req().post((String)map.get("cypher"), "{\"query\":\"START n=node(" + referenceNodeId + ") RETURN n\"}");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        response.close();
    }
}

