/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.startup.healthcheck;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.server.ServerTestUtils;
import org.neo4j.server.startup.healthcheck.ConfigFileMustBePresentRule;

public class ConfigFileMustBePresentRuleTest {
    @Test
    public void shouldFailIfThereIsNoSystemPropertyForConfigFile() {
        ConfigFileMustBePresentRule rule = new ConfigFileMustBePresentRule();
        Assert.assertFalse((boolean)rule.execute(this.propertiesWithoutConfigFileLocation()));
    }

    @Test
    public void shouldFailIfThereIsNoConfigFileWhereTheSystemPropertyPoints() throws IOException {
        ConfigFileMustBePresentRule rule = new ConfigFileMustBePresentRule();
        File tempFile = ServerTestUtils.createTempPropertyFile();
        tempFile.delete();
        Assert.assertFalse((boolean)rule.execute(this.propertiesWithConfigFileLocation(tempFile)));
    }

    @Test
    public void shouldPassIfThereIsAConfigFileWhereTheSystemPropertyPoints() throws IOException {
        File propertyFile = ServerTestUtils.createTempPropertyFile();
        ServerTestUtils.writePropertyToFile("org.neo4j.server.database.location", "/tmp/foo.db", propertyFile);
        ConfigFileMustBePresentRule rule = new ConfigFileMustBePresentRule();
        Assert.assertTrue((boolean)rule.execute(this.propertiesWithConfigFileLocation(propertyFile)));
        propertyFile.delete();
    }

    private Properties propertiesWithoutConfigFileLocation() {
        System.clearProperty("org.neo4j.server.properties");
        return System.getProperties();
    }

    private Properties propertiesWithConfigFileLocation(File propertyFile) {
        System.setProperty("org.neo4j.server.properties", propertyFile.getAbsolutePath());
        return System.getProperties();
    }
}

