/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.guard;

import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.neo4j.kernel.guard.Guard;
import org.neo4j.kernel.guard.GuardException;

public class GuardingRequestFilter
implements Filter {
    private static final Log LOG = LogFactory.getLog(GuardingRequestFilter.class);
    private final Guard guard;
    private final int timeout;
    private final Timer timer = new Timer();

    public GuardingRequestFilter(Guard guard, int timeout) {
        this.guard = guard;
        this.timeout = timeout;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws ServletException, IOException {
        if (req instanceof HttpServletRequest && res instanceof HttpServletResponse) {
            HttpServletRequest request = (HttpServletRequest)req;
            HttpServletResponse response = (HttpServletResponse)res;
            int timeLimit = this.getTimeLimit(request);
            if (timeLimit <= 0) {
                chain.doFilter(req, res);
            } else {
                long valid = System.currentTimeMillis() + (long)timeLimit;
                this.guard.startTimeout(valid);
                TimerTask timerTask = new TimerTask(){

                    @Override
                    public void run() {
                        LOG.warn((Object)"request canceled");
                        LOG.error((Object)"TODO: restarting the server is not proper implemented, request was not canceled");
                    }
                };
                this.timer.schedule(timerTask, valid + 5000L);
                try {
                    chain.doFilter(req, res);
                }
                catch (GuardException e) {
                    response.setStatus(408);
                }
                finally {
                    timerTask.cancel();
                    this.guard.stop();
                }
            }
        } else {
            chain.doFilter(req, res);
        }
    }

    public void destroy() {
        this.timer.cancel();
    }

    private int getTimeLimit(HttpServletRequest request) {
        int timeLimit = this.timeout;
        String headerValue = request.getHeader("max-execution-time");
        if (headerValue != null) {
            int maxHeader = Integer.parseInt(headerValue);
            if (timeLimit < 0 || maxHeader > 0 && maxHeader < timeLimit) {
                return maxHeader;
            }
        }
        return timeLimit;
    }
}

