/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.domain;

import java.util.Map;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.traversal.PruneEvaluator;
import org.neo4j.helpers.Predicate;
import org.neo4j.kernel.Traversal;
import org.neo4j.server.rest.domain.EvaluationException;

abstract class EvaluatorFactory {
    private static final String BUILTIN = "builtin";
    private static final String KEY_LANGUAGE = "language";
    private static final String KEY_BODY = "body";
    private static final String KEY_NAME = "name";

    EvaluatorFactory() {
    }

    public static PruneEvaluator pruneEvaluator(Map<String, Object> description) {
        if (EvaluatorFactory.refersToBuiltInEvaluator(description)) {
            return EvaluatorFactory.builtInPruneEvaluator(description);
        }
        return new ScriptedPruneEvaluator(EvaluatorFactory.scriptEngine(description), (String)description.get(KEY_BODY));
    }

    public static Predicate<Path> returnFilter(Map<String, Object> description) {
        if (EvaluatorFactory.refersToBuiltInEvaluator(description)) {
            return EvaluatorFactory.builtInReturnFilter(description);
        }
        return new ScriptedReturnEvaluator(EvaluatorFactory.scriptEngine(description), (String)description.get(KEY_BODY));
    }

    private static boolean refersToBuiltInEvaluator(Map<String, Object> description) {
        String language = (String)description.get(KEY_LANGUAGE);
        return language.equals(BUILTIN);
    }

    private static PruneEvaluator builtInPruneEvaluator(Map<String, Object> description) {
        String name = (String)description.get(KEY_NAME);
        if (name.equalsIgnoreCase("none")) {
            return PruneEvaluator.NONE;
        }
        throw new EvaluationException("Unrecognized prune evaluator name '" + name + "'");
    }

    private static Predicate<Path> builtInReturnFilter(Map<String, Object> description) {
        String name = (String)description.get(KEY_NAME);
        if (name.equalsIgnoreCase("all")) {
            return Traversal.returnAll();
        }
        if (name.equalsIgnoreCase("all_but_start_node")) {
            return Traversal.returnAllButStartNode();
        }
        throw new EvaluationException("Unrecognized return evaluator name '" + name + "'");
    }

    private static ScriptEngine scriptEngine(Map<String, Object> description) {
        String language = (String)description.get(KEY_LANGUAGE);
        ScriptEngine engine = new ScriptEngineManager().getEngineByName(language);
        if (engine == null) {
            throw new EvaluationException("Unknown script language '" + language + "'");
        }
        return engine;
    }

    private static class ScriptedReturnEvaluator
    extends ScriptedEvaluator
    implements Predicate<Path> {
        ScriptedReturnEvaluator(ScriptEngine engine, String body) {
            super(engine, body);
        }

        public boolean accept(Path position) {
            return (Boolean)this.executor(position).eval(position);
        }
    }

    private static class ScriptedPruneEvaluator
    extends ScriptedEvaluator
    implements PruneEvaluator {
        ScriptedPruneEvaluator(ScriptEngine engine, String body) {
            super(engine, body);
        }

        public boolean pruneAfter(Path position) {
            return (Boolean)this.executor(position).eval(position);
        }
    }

    private static abstract class ScriptedEvaluator {
        private final ScriptEngine engine;
        private final String body;
        private ScriptExecutor executor;

        ScriptedEvaluator(ScriptEngine engine, String body) {
            this.engine = engine;
            this.body = body;
        }

        protected ScriptExecutor executor(Path position) {
            if (this.executor == null) {
                try {
                    SimpleScriptContext context = new SimpleScriptContext();
                    context.setAttribute("position", position, 100);
                    this.engine.setContext(context);
                    this.executor = this.engine instanceof Compilable ? new CompiledScriptExecutor(((Compilable)((Object)this.engine)).compile(this.body), context) : new EvalScriptExecutor(this.engine, this.body);
                    return this.executor;
                }
                catch (ScriptException e) {
                    throw new EvaluationException(e);
                }
            }
            return this.executor;
        }
    }

    private static class CompiledScriptExecutor
    extends ScriptExecutor {
        private final CompiledScript script;
        private final ScriptContext context;

        CompiledScriptExecutor(CompiledScript script, ScriptContext context) {
            this.script = script;
            this.context = context;
        }

        @Override
        Object eval(Path position) {
            try {
                this.context.setAttribute("position", position, 100);
                return this.script.eval(this.context);
            }
            catch (ScriptException e) {
                throw new EvaluationException(e);
            }
        }
    }

    private static class EvalScriptExecutor
    extends ScriptExecutor {
        private final ScriptEngine script;
        private final String body;

        EvalScriptExecutor(ScriptEngine script, String body) {
            this.script = script;
            this.body = body;
        }

        @Override
        Object eval(Path position) {
            try {
                this.script.getContext().setAttribute("position", position, 100);
                return this.script.eval(this.body);
            }
            catch (ScriptException e) {
                throw new EvaluationException(e);
            }
        }
    }

    private static abstract class ScriptExecutor {
        private ScriptExecutor() {
        }

        abstract Object eval(Path var1);
    }
}

