/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.server.NeoServerWithEmbeddedWebServer;
import org.neo4j.server.helpers.ServerBuilder;
import org.neo4j.test.server.ExclusiveServerTestBase;

public class HttpsEnabledTest
extends ExclusiveServerTestBase {
    private NeoServerWithEmbeddedWebServer server;

    @After
    public void stopTheServer() {
        this.server.stop();
    }

    @Test
    public void serverShouldSupportSsl() throws Exception {
        this.server = ServerBuilder.server().withHttpsEnabled().build();
        this.server.start();
        Assert.assertThat((Object)this.server.getHttpsEnabled(), (Matcher)Matchers.is((Object)true));
        this.trustAllSslCerts();
        Client client = Client.create();
        ClientResponse r = (ClientResponse)client.resource(this.server.httpsUri()).get(ClientResponse.class);
        Assert.assertThat((Object)r.getStatus(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void webadminShouldBeRetrievableViaSsl() throws Exception {
        this.server = ServerBuilder.server().withHttpsEnabled().build();
        this.server.start();
        Assert.assertThat((Object)this.server.getHttpsEnabled(), (Matcher)Matchers.is((Object)true));
        this.trustAllSslCerts();
        Client client = Client.create();
        ClientResponse r = (ClientResponse)client.resource(this.server.httpsUri().toASCIIString() + "webadmin/").get(ClientResponse.class);
        Assert.assertThat((Object)r.getStatus(), (Matcher)Matchers.is((Object)200));
    }

    private void trustAllSslCerts() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

