/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.IOException;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.server.NeoServerWithEmbeddedWebServer;
import org.neo4j.server.helpers.ServerBuilder;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.test.server.ExclusiveServerTestBase;

public class ServerConfigTest
extends ExclusiveServerTestBase {
    private NeoServerWithEmbeddedWebServer server;

    @After
    public void stopTheServer() {
        this.server.stop();
    }

    @Test
    public void shouldPickUpPortFromConfig() throws Exception {
        int NON_DEFAULT_PORT = 4321;
        this.server = ServerBuilder.server().onPort(4321).build();
        this.server.start();
        Assert.assertEquals((long)4321L, (long)this.server.getWebServerPort());
        JaxRsResponse response = new RestRequest(this.server.baseUri()).get();
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        response.close();
    }

    @Test
    public void shouldPickupRelativeUrisForWebAdminAndWebAdminRest() throws IOException {
        String webAdminDataUri = "/a/different/webadmin/data/uri/";
        String webAdminManagementUri = "/a/different/webadmin/management/uri/";
        this.server = ServerBuilder.server().withRelativeWebDataAdminUriPath(webAdminDataUri).withRelativeWebAdminUriPath(webAdminManagementUri).build();
        this.server.start();
        JaxRsResponse response = new RestRequest().get("http://localhost:7474" + webAdminDataUri, MediaType.TEXT_HTML_TYPE);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        response = new RestRequest().get("http://localhost:7474" + webAdminManagementUri);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        response.close();
    }

    @Test
    public void shouldGenerateWADLWhenExplicitlyEnabledInConfig() throws IOException {
        this.server = ServerBuilder.server().withProperty("unsupported_wadl_generation_enabled", "true").build();
        this.server.start();
        JaxRsResponse response = new RestRequest().get("http://localhost:7474/application.wadl", MediaType.WILDCARD_TYPE);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/vnd.sun.wadl+xml", ((List)response.getHeaders().get((Object)"Content-Type")).iterator().next());
        Assert.assertThat((Object)response.getEntity(String.class), (Matcher)Matchers.containsString((String)"<application xmlns=\"http://wadl.dev.java.net/2009/02\">"));
    }

    @Test
    public void shouldNotGenerateWADLWhenNotExplicitlyEnabledInConfig() throws IOException {
        this.server = ServerBuilder.server().build();
        this.server.start();
        JaxRsResponse response = new RestRequest().get("http://localhost:7474/application.wadl", MediaType.WILDCARD_TYPE);
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void shouldNotGenerateWADLWhenExplicitlyDisabledInConfig() throws IOException {
        this.server = ServerBuilder.server().withProperty("unsupported_wadl_generation_enabled", "false").build();
        this.server.start();
        JaxRsResponse response = new RestRequest().get("http://localhost:7474/application.wadl", MediaType.WILDCARD_TYPE);
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }
}

