/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.util.Arrays;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.server.Bootstrapper;
import org.neo4j.server.database.GraphDatabaseFactory;
import org.neo4j.server.modules.DiscoveryModule;
import org.neo4j.server.modules.ManagementApiModule;
import org.neo4j.server.modules.RESTApiModule;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.modules.StatisticModule;
import org.neo4j.server.modules.ThirdPartyJAXRSModule;
import org.neo4j.server.modules.WebAdminModule;
import org.neo4j.server.startup.healthcheck.ConfigFileMustBePresentRule;
import org.neo4j.server.startup.healthcheck.HTTPLoggingPreparednessRule;
import org.neo4j.server.startup.healthcheck.Neo4jPropertiesMustExistRule;
import org.neo4j.server.startup.healthcheck.StartupHealthCheckRule;

public class NeoServerBootstrapper
extends Bootstrapper {
    @Override
    public Iterable<StartupHealthCheckRule> getHealthCheckRules() {
        return Arrays.asList(new ConfigFileMustBePresentRule(), new Neo4jPropertiesMustExistRule(), new HTTPLoggingPreparednessRule());
    }

    @Override
    public Iterable<Class<? extends ServerModule>> getServerModules() {
        return Arrays.asList(DiscoveryModule.class, RESTApiModule.class, ManagementApiModule.class, ThirdPartyJAXRSModule.class, WebAdminModule.class, StatisticModule.class);
    }

    @Override
    protected GraphDatabaseFactory getGraphDatabaseFactory(Configuration configuration) {
        return new GraphDatabaseFactory(){

            @Override
            public GraphDatabaseAPI createDatabase(String databaseStoreDirectory, Map<String, String> databaseProperties) {
                return (GraphDatabaseAPI)new org.neo4j.graphdb.factory.GraphDatabaseFactory().newEmbeddedDatabaseBuilder(databaseStoreDirectory).setConfig(databaseProperties).newGraphDatabase();
            }
        };
    }
}

