(function() {
  var __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; }, __hasProp = Object.prototype.hasOwnProperty, __extends = function(child, parent) {
    for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; }
    function ctor() { this.constructor = child; }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor;
    child.__super__ = parent.prototype;
    return child;
  };
  define(['./search/QueuedSearch', './views/DataBrowserView', './visualization/views/VisualizationSettingsView', './visualization/views/VisualizationProfileView', './models/DataBrowserState', './DataBrowserSettings', 'ribcage/Router'], function(QueuedSearch, DataBrowserView, VisualizationSettingsView, VisualizationProfileView, DataBrowserState, DataBrowserSettings, Router) {
    var DataBrowserRouter;
    return DataBrowserRouter = (function() {
      __extends(DataBrowserRouter, Router);
      function DataBrowserRouter() {
        this.getVisualizationProfileView = __bind(this.getVisualizationProfileView, this);
        this.getDataBrowserView = __bind(this.getDataBrowserView, this);
        this.showResult = __bind(this.showResult, this);
        this.queryChanged = __bind(this.queryChanged, this);
        this.switchDataView = __bind(this.switchDataView, this);
        this.focusOnSearchField = __bind(this.focusOnSearchField, this);
        this.editVisualizationProfile = __bind(this.editVisualizationProfile, this);
        this.createVisualizationProfile = __bind(this.createVisualizationProfile, this);
        this.visualizationSettings = __bind(this.visualizationSettings, this);
        this.search = __bind(this.search, this);
        this.base = __bind(this.base, this);
        this.init = __bind(this.init, this);
        DataBrowserRouter.__super__.constructor.apply(this, arguments);
      }
      DataBrowserRouter.prototype.routes = {
        "/data/": "base",
        "/data/search/*query": "search",
        "/data/visualization/settings/": "visualizationSettings",
        "/data/visualization/settings/profile/": "createVisualizationProfile",
        "/data/visualization/settings/profile/:id/": "editVisualizationProfile"
      };
      DataBrowserRouter.prototype.shortcuts = {
        "s": "focusOnSearchField",
        "v": "switchDataView"
      };
      DataBrowserRouter.prototype.init = function(appState) {
        this.appState = appState;
        this.server = appState.get("server");
        this.searcher = new QueuedSearch(this.server);
        this.dataModel = new DataBrowserState({
          server: this.server
        });
        return this.dataModel.bind("change:query", this.queryChanged);
      };
      DataBrowserRouter.prototype.base = function() {
        return this.queryChanged();
      };
      DataBrowserRouter.prototype.search = function(query) {
        this.saveLocation();
        query = decodeURIComponent(query);
        while (query.charAt(query.length - 1) === "/") {
          query = query.substr(0, query.length - 1);
        }
        this.dataModel.setQuery(query);
        return this.appState.set({
          mainView: this.getDataBrowserView()
        });
      };
      DataBrowserRouter.prototype.visualizationSettings = function() {
        var _ref;
        this.saveLocation();
        if ((_ref = this.visualizationSettingsView) == null) {
          this.visualizationSettingsView = new VisualizationSettingsView({
            dataBrowserSettings: this.getDataBrowserSettings()
          });
        }
        return this.appState.set({
          mainView: this.visualizationSettingsView
        });
      };
      DataBrowserRouter.prototype.createVisualizationProfile = function() {
        var v;
        this.saveLocation();
        v = this.getVisualizationProfileView();
        v.setIsCreateMode(true);
        return this.appState.set({
          mainView: v
        });
      };
      DataBrowserRouter.prototype.editVisualizationProfile = function(id) {
        var profile, profiles, v;
        this.saveLocation();
        profiles = this.getDataBrowserSettings().getVisualizationProfiles();
        profile = profiles.get(id);
        v = this.getVisualizationProfileView();
        v.setProfileToManage(profile);
        return this.appState.set({
          mainView: v
        });
      };
      DataBrowserRouter.prototype.focusOnSearchField = function(ev) {
        this.base();
        return setTimeout(function() {
          return $("#data-console").focus();
        }, 1);
      };
      DataBrowserRouter.prototype.switchDataView = function(ev) {
        return this.getDataBrowserView().switchView();
      };
      DataBrowserRouter.prototype.queryChanged = function() {
        var query, url;
        query = this.dataModel.get("query");
        if (query === null) {
          return this.search("0");
        }
        url = "#/data/search/" + (encodeURIComponent(query)) + "/";
        if (location.hash !== url) {
          location.hash = url;
        }
        if (this.dataModel.get("queryOutOfSyncWithData")) {
          return this.searcher.exec(this.dataModel.get("query")).then(this.showResult, this.showResult);
        }
      };
      DataBrowserRouter.prototype.showResult = function(result) {
        return this.dataModel.setData(result);
      };
      DataBrowserRouter.prototype.getDataBrowserView = function() {
        var _ref;
        return (_ref = this.view) != null ? _ref : this.view = new DataBrowserView({
          state: this.appState,
          dataModel: this.dataModel
        });
      };
      DataBrowserRouter.prototype.getVisualizationProfileView = function() {
        var _ref;
        return (_ref = this.visualizationProfileView) != null ? _ref : this.visualizationProfileView = new VisualizationProfileView({
          dataBrowserSettings: this.getDataBrowserSettings()
        });
      };
      DataBrowserRouter.prototype.getDataBrowserSettings = function() {
        var _ref;
        return (_ref = this.dataBrowserSettings) != null ? _ref : this.dataBrowserSettings = new DataBrowserSettings(this.appState.getSettings());
      };
      return DataBrowserRouter;
    })();
  });
}).call(this);
