/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.web;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.server.ServerTestUtils;
import org.neo4j.server.database.Database;
import org.neo4j.server.rest.domain.GraphDbHelper;
import org.neo4j.server.rest.domain.TraverserReturnType;
import org.neo4j.server.rest.paging.Clock;
import org.neo4j.server.rest.paging.FakeClock;
import org.neo4j.server.rest.paging.LeaseManager;
import org.neo4j.server.rest.repr.InputFormat;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.formats.JsonFormat;
import org.neo4j.server.rest.web.RestfulGraphDatabase;
import org.neo4j.test.server.EntityOutputFormat;

public class PagingTraversalTest {
    private static final String BASE_URI = "http://neo4j.org:7474/";
    private RestfulGraphDatabase service;
    private Database database;
    private EntityOutputFormat output;
    private GraphDbHelper helper;
    private LeaseManager leaseManager;
    private static final int SIXTY_SECONDS = 60;

    @Before
    public void startDatabase() throws IOException {
        this.database = new Database(ServerTestUtils.EPHEMERAL_GRAPH_DATABASE_FACTORY, null);
        this.helper = new GraphDbHelper(this.database);
        this.output = new EntityOutputFormat((RepresentationFormat)new JsonFormat(), URI.create(BASE_URI), null);
        this.leaseManager = new LeaseManager((Clock)new FakeClock());
        this.service = new RestfulGraphDatabase(this.uriInfo(), this.database, (InputFormat)new JsonFormat(), (OutputFormat)this.output, this.leaseManager);
    }

    @After
    public void shutdownDatabase() throws Throwable {
        this.database.shutdown();
    }

    @Test
    public void shouldLodgeAPagingTraverserAndTraverseTheFirstPageBeforeRespondingWith201() {
        Response response = this.createAPagedTraverser();
        Assert.assertEquals((long)201L, (long)response.getStatus());
        String responseUri = ((List)response.getMetadata().get((Object)"Location")).get(0).toString();
        Assert.assertThat((Object)responseUri, (Matcher)Matchers.containsString((String)"/node/1/paged/traverse/node/"));
        Assert.assertNotNull((Object)response.getEntity());
        System.out.println(response.getEntity().toString());
        Assert.assertThat((Object)response.getEntity().toString(), (Matcher)Matchers.containsString((String)"\"name\" : \"19\""));
    }

    @Test
    public void givenAPageTraversalHasBeenCreatedShouldYieldNextPageAndRespondWith200() throws Exception {
        Response response = this.createAPagedTraverser();
        String traverserId = this.parseTraverserIdFromLocationUri(response);
        response = this.service.pagedTraverse(traverserId, TraverserReturnType.node);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertNotNull((Object)response.getEntity());
        Assert.assertThat((Object)response.getEntity().toString(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"\"name\" : \"19\"")));
        Assert.assertThat((Object)response.getEntity().toString(), (Matcher)Matchers.containsString((String)"\"name\" : \"91\""));
    }

    @Test
    public void shouldRespondWith404WhenNoSuchTraversalRegistered() {
        Response response = this.service.pagedTraverse("anUnlikelyTraverserId", TraverserReturnType.node);
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void shouldRespondWith404WhenTraversalHasExpired() {
        Response response = this.createAPagedTraverser();
        ((FakeClock)this.leaseManager.getClock()).forwardMinutes(2);
        String traverserId = this.parseTraverserIdFromLocationUri(response);
        response = this.service.pagedTraverse(traverserId, TraverserReturnType.node);
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void shouldRespondWith400OnNegativePageSize() {
        long arbitraryStartNodeId = 1L;
        int negativePageSize = -5;
        String arbitraryDescription = this.description();
        Response response = this.service.createPagedTraverser(arbitraryStartNodeId, TraverserReturnType.node, negativePageSize, 60, arbitraryDescription);
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }

    @Test
    public void shouldRespondWith400OnLeaseTime() {
        long arbitraryStartNodeId = 1L;
        int arbitraryPageSize = 5;
        String arbitraryDescription = this.description();
        Response response = this.service.createPagedTraverser(arbitraryStartNodeId, TraverserReturnType.node, arbitraryPageSize, -5, arbitraryDescription);
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }

    @Test
    public void shouldRenewLeaseAtEachTraversal() {
        Response response = this.createAPagedTraverser();
        String traverserId = this.parseTraverserIdFromLocationUri(response);
        ((FakeClock)this.leaseManager.getClock()).forwardSeconds(30L);
        response = this.service.pagedTraverse(traverserId, TraverserReturnType.node);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        ((FakeClock)this.leaseManager.getClock()).forwardSeconds(30L);
        response = this.service.pagedTraverse(traverserId, TraverserReturnType.node);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        ((FakeClock)this.leaseManager.getClock()).forwardMinutes(10);
        response = this.service.pagedTraverse(traverserId, TraverserReturnType.node);
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void shouldBeAbleToRemoveALeaseOnceOnly() {
        Response response = this.createAPagedTraverser();
        String traverserId = this.parseTraverserIdFromLocationUri(response);
        Assert.assertEquals((long)200L, (long)this.service.removePagedTraverser(traverserId).getStatus());
        Assert.assertEquals((long)404L, (long)this.service.removePagedTraverser(traverserId).getStatus());
    }

    private UriInfo uriInfo() {
        UriInfo mockUriInfo = (UriInfo)Mockito.mock(UriInfo.class);
        try {
            Mockito.when((Object)mockUriInfo.getBaseUri()).thenReturn((Object)new URI(BASE_URI));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return mockUriInfo;
    }

    private Response createAPagedTraverser() {
        long startNodeId = this.createListOfNodes(1000);
        String description = this.description();
        int PAGE_SIZE = 10;
        Response response = this.service.createPagedTraverser(startNodeId, TraverserReturnType.node, 10, 60, description);
        return response;
    }

    private String description() {
        String description = "{\"prune_evaluator\":{\"language\":\"builtin\",\"name\":\"none\"},\"return_filter\":{\"language\":\"javascript\",\"body\":\"position.endNode().getProperty('name').contains('9');\"},\"order\":\"depth first\",\"relationships\":{\"type\":\"PRECEDES\",\"direction\":\"out\"}}";
        return description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long createListOfNodes(int numberOfNodes) {
        Transaction tx = this.database.graph.beginTx();
        try {
            long zerothNode;
            long previousNodeId = zerothNode = this.helper.createNode(MapUtil.map((Object[])new Object[]{"name", String.valueOf(0)}));
            for (int i = 1; i < numberOfNodes; ++i) {
                long currentNodeId = this.helper.createNode(MapUtil.map((Object[])new Object[]{"name", String.valueOf(i)}));
                this.database.graph.getNodeById(previousNodeId).createRelationshipTo(this.database.graph.getNodeById(currentNodeId), (RelationshipType)DynamicRelationshipType.withName((String)"PRECEDES"));
            }
            tx.success();
            long l = zerothNode;
            return l;
        }
        finally {
            tx.finish();
        }
    }

    private String parseTraverserIdFromLocationUri(Response response) {
        String locationUri = ((List)response.getMetadata().get((Object)"Location")).get(0).toString();
        return locationUri.substring(locationUri.lastIndexOf("/") + 1);
    }
}

