/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rrd;

import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.server.database.Database;
import org.neo4j.server.database.WrappingDatabase;
import org.neo4j.server.rrd.sampler.PropertyCountSampleable;
import org.neo4j.test.ImpermanentGraphDatabase;

public class PropertyCountSampleableTest {
    public Database db;
    public PropertyCountSampleable sampleable;

    @Test
    public void emptyDbHasZeroNodesInUse() {
        MatcherAssert.assertThat((Object)this.sampleable.getValue(), (Matcher)Is.is((Object)0.0));
    }

    @Test
    public void addANodeAndSampleableGoesUp() {
        this.addPropertyToReferenceNode();
        MatcherAssert.assertThat((Object)this.sampleable.getValue(), (Matcher)Is.is((Object)1.0));
        this.addNodeIntoGraph();
        this.addNodeIntoGraph();
        MatcherAssert.assertThat((Object)this.sampleable.getValue(), (Matcher)Is.is((Object)3.0));
    }

    private void addNodeIntoGraph() {
        Transaction tx = this.db.graph.beginTx();
        Node referenceNode = this.db.graph.getReferenceNode();
        Node myNewNode = this.db.graph.createNode();
        myNewNode.setProperty("id", (Object)UUID.randomUUID().toString());
        myNewNode.createRelationshipTo(referenceNode, new RelationshipType(){

            public String name() {
                return "knows_about";
            }
        });
        tx.success();
        tx.finish();
    }

    private void addPropertyToReferenceNode() {
        Transaction tx = this.db.graph.beginTx();
        Node n = this.db.graph.getReferenceNode();
        n.setProperty("monkey", (Object)"rock!");
        tx.success();
        tx.finish();
    }

    @Before
    public void setUp() throws Exception {
        this.db = new WrappingDatabase((GraphDatabaseAPI)new ImpermanentGraphDatabase());
        this.sampleable = new PropertyCountSampleable(this.db.graph);
    }

    @After
    public void shutdownDatabase() throws Throwable {
        this.db.getGraph().shutdown();
    }
}

