/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rrd;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.MapConfiguration;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.server.database.Database;
import org.neo4j.server.database.WrappingDatabase;
import org.neo4j.server.rrd.JobScheduler;
import org.neo4j.server.rrd.RrdFactory;
import org.neo4j.server.rrd.Sampleable;
import org.neo4j.test.ImpermanentGraphDatabase;
import org.rrd4j.ConsolFun;
import org.rrd4j.DsType;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.RrdDef;

public class RrdFactoryTest {
    private Configuration config;
    private Database db;

    @Before
    public void setUp() throws IOException {
        this.config = new MapConfiguration(new HashMap());
        this.db = new WrappingDatabase((GraphDatabaseAPI)new ImpermanentGraphDatabase());
    }

    @After
    public void tearDown() {
        this.db.getGraph().shutdown();
    }

    @Test
    public void shouldTakeDirectoryLocationFromConfig() {
        String expected = "target/rrd-test";
        this.config.addProperty("org.neo4j.server.webadmin.rrdb.location", (Object)expected);
        TestableRrdFactory factory = this.createRrdFactory();
        factory.createRrdDbAndSampler(this.db, new NullJobScheduler());
        Assert.assertThat((Object)factory.directoryUsed, (Matcher)CoreMatchers.is((Object)expected));
    }

    @Test
    public void recreateDatabaseIfWrongStepsize() {
        String expected = "target/rrd-test";
        this.config.addProperty("org.neo4j.server.webadmin.rrdb.location", (Object)expected);
        TestableRrdFactory factory = this.createRrdFactory();
        factory.createRrdDbAndSampler(this.db, new NullJobScheduler());
        Assert.assertThat((Object)factory.directoryUsed, (Matcher)CoreMatchers.is((Object)expected));
    }

    @Test
    public void shouldCreateRrdInAGoodDefaultPlace() throws IOException {
        TestableRrdFactory factory = this.createRrdFactory();
        File rrd = new File(this.db.getLocation(), "rrd");
        RrdDef rrdDef = new RrdDef(rrd.getAbsolutePath(), 3000L);
        rrdDef.addDatasource("test", DsType.GAUGE, 1L, Double.NaN, Double.NaN);
        rrdDef.addArchive(ConsolFun.AVERAGE, 0.2, 1, 1600);
        RrdDb r = new RrdDb(rrdDef);
        r.close();
        RrdDb rrdDbAndSampler = factory.createRrdDbAndSampler(this.db, new NullJobScheduler());
        Assert.assertThat((Object)new File(factory.directoryUsed).getParentFile().list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String s) {
                return s.startsWith("rrd-invalid");
            }
        }).length, (Matcher)CoreMatchers.is((Object)1));
        rrdDbAndSampler.close();
    }

    private TestableRrdFactory createRrdFactory() {
        return new TestableRrdFactory(this.config);
    }

    private static class NullJobScheduler
    implements JobScheduler {
        private NullJobScheduler() {
        }

        public void scheduleAtFixedRate(Runnable job, String name, long delay, long period) {
        }
    }

    private static class TestableRrdFactory
    extends RrdFactory {
        public String directoryUsed;

        public TestableRrdFactory(Configuration config) {
            super(config);
        }

        protected RrdDb createRrdb(String inDirectory, Sampleable ... sampleables) {
            this.directoryUsed = inDirectory;
            return super.createRrdb(inDirectory, sampleables);
        }
    }
}

