/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.webadmin.console;

import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.server.database.Database;
import org.neo4j.server.database.WrappingDatabase;
import org.neo4j.server.webadmin.console.GremlinSession;
import org.neo4j.server.webadmin.console.ScriptSession;
import org.neo4j.test.ImpermanentGraphDatabase;

public class GremlinSessionTest {
    private static final String NEWLINE = System.getProperty("line.separator");
    private static ScriptSession session;
    private static Database database;

    @Test
    public void retrievesTheReferenceNode() {
        String result = (String)session.evaluate("g").first();
        Assert.assertEquals((Object)String.format("neo4jgraph[%s]" + NEWLINE, GremlinSessionTest.database.graph.toString()), (Object)result);
    }

    @Test
    public void multiLineTest() {
        String result = (String)session.evaluate("for (i in 0..2) {").first();
        result = (String)session.evaluate("println 'hi'").first();
        result = (String)session.evaluate("}").first();
        result = (String)session.evaluate("i = 2").first();
        Assert.assertEquals((Object)("2" + NEWLINE), (Object)result);
    }

    @Test
    public void testGremlinVersion() {
        String result = (String)session.evaluate("Gremlin.version()").first();
        Assert.assertEquals((Object)("1.5" + NEWLINE), (Object)result);
    }

    @Test
    public void canCreateNodesAndEdgesInGremlinLand() {
        String result = (String)session.evaluate("g.addVertex(null)").first();
        Assert.assertEquals((Object)("v[1]" + NEWLINE), (Object)result);
        result = (String)session.evaluate("g.V.next(2)").first();
        Assert.assertEquals((Object)("v[0]" + NEWLINE + "v[1]" + NEWLINE), (Object)result);
        result = (String)session.evaluate("g.addVertex(null)").first();
        Assert.assertEquals((Object)("v[2]" + NEWLINE), (Object)result);
        result = (String)session.evaluate("g.addEdge(g.v(1), g.v(2), 'knows')").first();
        Assert.assertEquals((Object)("e[0][1-knows->2]" + NEWLINE), (Object)result);
        result = (String)session.evaluate("g.v(1).out").first();
        Assert.assertEquals((Object)("v[2]" + NEWLINE), (Object)result);
    }

    @BeforeClass
    public static void setUp() throws Exception {
        database = new WrappingDatabase((GraphDatabaseAPI)new ImpermanentGraphDatabase());
        session = new GremlinSession(database);
    }

    @AfterClass
    public static void shutdownDatabase() {
        database.getGraph().shutdown();
    }
}

