/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.util.Arrays;
import org.neo4j.server.AbstractNeoServer;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.database.CommunityDatabase;
import org.neo4j.server.database.Database;
import org.neo4j.server.modules.DiscoveryModule;
import org.neo4j.server.modules.ManagementApiModule;
import org.neo4j.server.modules.RESTApiModule;
import org.neo4j.server.modules.SecurityRulesModule;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.modules.StatisticModule;
import org.neo4j.server.modules.ThirdPartyJAXRSModule;
import org.neo4j.server.modules.WebAdminModule;
import org.neo4j.server.startup.healthcheck.ConfigFileMustBePresentRule;
import org.neo4j.server.startup.healthcheck.HTTPLoggingPreparednessRule;
import org.neo4j.server.startup.healthcheck.Neo4jPropertiesMustExistRule;
import org.neo4j.server.startup.healthcheck.StartupHealthCheck;
import org.neo4j.server.web.Jetty6WebServer;
import org.neo4j.server.web.WebServer;

public class CommunityNeoServer
extends AbstractNeoServer {
    protected CommunityNeoServer() {
    }

    public CommunityNeoServer(Configurator configurator) {
        this.configurator = configurator;
        this.init();
    }

    @Override
    protected StartupHealthCheck createHealthCheck() {
        return new StartupHealthCheck(new ConfigFileMustBePresentRule(), new Neo4jPropertiesMustExistRule(), new HTTPLoggingPreparednessRule());
    }

    @Override
    protected Iterable<ServerModule> createServerModules() {
        return Arrays.asList(new DiscoveryModule(this.webServer), new RESTApiModule(this.webServer, this.database, this.configurator.configuration()), new ManagementApiModule(this.webServer, this.configurator.configuration()), new ThirdPartyJAXRSModule(this.webServer, this.configurator), new WebAdminModule(this.webServer, this.configurator.configuration(), this.database), new StatisticModule(this.webServer, this.statisticsCollector), new SecurityRulesModule(this.webServer, this.configurator.configuration()));
    }

    @Override
    protected Database createDatabase() {
        return new CommunityDatabase(this.configurator.configuration());
    }

    @Override
    protected WebServer createWebServer() {
        return new Jetty6WebServer();
    }
}

