/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.startup.healthcheck;

import java.util.Properties;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.server.logging.InMemoryAppender;
import org.neo4j.server.startup.healthcheck.StartupHealthCheck;
import org.neo4j.server.startup.healthcheck.StartupHealthCheckRule;

public class StartupHealthCheckTest {
    @Test
    public void shouldPassWithNoRules() {
        StartupHealthCheck check = new StartupHealthCheck(new StartupHealthCheckRule[0]);
        Assert.assertTrue((boolean)check.run());
    }

    @Test
    public void shouldRunAllHealthChecksToCompletionIfNonFail() {
        StartupHealthCheck check = new StartupHealthCheck(this.getPassingRules());
        Assert.assertTrue((boolean)check.run());
    }

    @Test
    public void shouldFailIfOneOrMoreHealthChecksFail() {
        StartupHealthCheck check = new StartupHealthCheck(this.getWithOneFailingRule());
        Assert.assertFalse((boolean)check.run());
    }

    @Test
    public void shouldLogFailedRule() {
        StartupHealthCheck check = new StartupHealthCheck(this.getWithOneFailingRule());
        InMemoryAppender appender = new InMemoryAppender(StartupHealthCheck.log);
        check.run();
        Assert.assertThat((Object)appender.toString(), (Matcher)Matchers.containsString((String)": blah blah"));
    }

    @Test
    public void shouldAdvertiseFailedRule() {
        StartupHealthCheck check = new StartupHealthCheck(this.getWithOneFailingRule());
        check.run();
        Assert.assertNotNull((Object)check.failedRule());
    }

    private StartupHealthCheckRule[] getWithOneFailingRule() {
        StartupHealthCheckRule[] rules = new StartupHealthCheckRule[5];
        for (int i = 0; i < rules.length; ++i) {
            rules[i] = new StartupHealthCheckRule(){

                public boolean execute(Properties properties) {
                    return true;
                }

                public String getFailureMessage() {
                    return "blah blah";
                }
            };
        }
        rules[rules.length / 2] = new StartupHealthCheckRule(){

            public boolean execute(Properties properties) {
                return false;
            }

            public String getFailureMessage() {
                return "blah blah";
            }
        };
        return rules;
    }

    private StartupHealthCheckRule[] getPassingRules() {
        StartupHealthCheckRule[] rules = new StartupHealthCheckRule[5];
        for (int i = 0; i < rules.length; ++i) {
            rules[i] = new StartupHealthCheckRule(){

                public boolean execute(Properties properties) {
                    return true;
                }

                public String getFailureMessage() {
                    return "blah blah";
                }
            };
        }
        return rules;
    }
}

