/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.webadmin.rest;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.server.database.Database;
import org.neo4j.server.database.WrappingDatabase;
import org.neo4j.server.rest.repr.InputFormat;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.formats.JsonFormat;
import org.neo4j.server.webadmin.console.GremlinSession;
import org.neo4j.server.webadmin.console.ScriptSession;
import org.neo4j.server.webadmin.rest.ConsoleService;
import org.neo4j.server.webadmin.rest.SessionFactory;
import org.neo4j.test.ImpermanentGraphDatabase;

public class GremlinConsoleServiceTest
implements SessionFactory {
    private ConsoleService consoleService;
    private Database database;
    private final URI uri = URI.create("http://peteriscool.com:6666/");

    @Test
    public void retrievesTheReferenceNode() throws UnsupportedEncodingException {
        Response evaluatedGremlinResponse = this.consoleService.exec((InputFormat)new JsonFormat(), "{ \"command\" : \"g.addVertex(null);g.v(1)\" }");
        Assert.assertEquals((long)200L, (long)evaluatedGremlinResponse.getStatus());
        String response = this.decode(evaluatedGremlinResponse);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"v[1]"));
    }

    private String decode(Response response) throws UnsupportedEncodingException {
        return new String((byte[])response.getEntity(), "UTF-8");
    }

    @Test
    public void canCreateNodesInGremlinLand() throws UnsupportedEncodingException {
        Response evaluatedGremlinResponse = this.consoleService.exec((InputFormat)new JsonFormat(), "{ \"command\" : \"g.addVertex(null)\" }");
        Assert.assertEquals((long)200L, (long)evaluatedGremlinResponse.getStatus());
        String response = this.decode(evaluatedGremlinResponse);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"v[1]"));
        evaluatedGremlinResponse = this.consoleService.exec((InputFormat)new JsonFormat(), "{ \"command\" : \"g.addVertex(null)\" }");
        response = this.decode(evaluatedGremlinResponse);
        Assert.assertEquals((long)200L, (long)evaluatedGremlinResponse.getStatus());
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"v[2]"));
    }

    @Test
    public void correctRepresentation() throws URISyntaxException, UnsupportedEncodingException {
        Response consoleResponse = this.consoleService.getServiceDefinition();
        Assert.assertEquals((long)200L, (long)consoleResponse.getStatus());
        String response = this.decode(consoleResponse);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"resources"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)this.uri.toString()));
    }

    @Before
    public void setUp() throws Exception {
        this.database = new WrappingDatabase((AbstractGraphDatabase)new ImpermanentGraphDatabase());
        this.consoleService = new ConsoleService((SessionFactory)this, this.database, new OutputFormat((RepresentationFormat)new JsonFormat(), this.uri, null));
    }

    @After
    public void shutdownDatabase() {
        this.database.getGraph().shutdown();
    }

    public ScriptSession createSession(String engineName, Database database) {
        return new GremlinSession(database);
    }
}

