/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.server;

import java.io.IOException;
import org.neo4j.server.NeoServer;
import org.neo4j.server.helpers.ServerHelper;

final class ServerHolder
extends Thread {
    private static AssertionError allocation;
    private static NeoServer server;

    static synchronized NeoServer allocate() throws IOException {
        if (allocation != null) {
            throw allocation;
        }
        if (server == null) {
            server = ServerHolder.startServer();
        }
        allocation = new AssertionError((Object)"The server was allocated from here but not released properly");
        return server;
    }

    static synchronized void release(NeoServer server) {
        if (server == null) {
            return;
        }
        if (server != ServerHolder.server) {
            throw new AssertionError((Object)"trying to release a server not allocated from here");
        }
        if (allocation == null) {
            throw new AssertionError((Object)"releasing the server although it is not allocated");
        }
        allocation = null;
    }

    static synchronized void ensureNotRunning() {
        if (allocation != null) {
            throw allocation;
        }
        ServerHolder.shutdown();
    }

    private static NeoServer startServer() throws IOException {
        NeoServer server = ServerHelper.createNonPersistentServer();
        return server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void shutdown() {
        allocation = null;
        try {
            if (server != null) {
                server.stop();
            }
        }
        finally {
            server = null;
        }
    }

    @Override
    public void run() {
        ServerHolder.shutdown();
    }

    private ServerHolder() {
        super(ServerHolder.class.getName());
    }

    static {
        Runtime.getRuntime().addShutdownHook(new ServerHolder());
    }
}

