/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.web;

import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.neo4j.cypher.javacompat.ExecutionEngine;
import org.neo4j.cypher.javacompat.ExecutionResult;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.server.database.Database;
import org.neo4j.server.rest.repr.BadInputException;
import org.neo4j.server.rest.repr.CypherResultRepresentation;
import org.neo4j.server.rest.repr.InputFormat;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.Representation;

@Path(value="/cypher")
public class CypherService {
    private static final String PARAMS_KEY = "params";
    private static final String QUERY_KEY = "query";
    private ExecutionEngine executionEngine;
    private OutputFormat output;
    private InputFormat input;

    public CypherService(@Context Database database, @Context InputFormat input, @Context OutputFormat output) {
        this.executionEngine = new ExecutionEngine((GraphDatabaseService)database.getGraph());
        this.input = input;
        this.output = output;
    }

    @POST
    public Response cypher(String body) throws BadInputException {
        Map command = this.input.readMap(body, new String[0]);
        if (!command.containsKey(QUERY_KEY)) {
            return this.output.badRequest(new BadInputException("You have to provide the 'query' parameter."));
        }
        String query = (String)command.get(QUERY_KEY);
        Map params = (Map)(command.containsKey(PARAMS_KEY) ? command.get(PARAMS_KEY) : new HashMap());
        try {
            ExecutionResult result = this.executionEngine.execute(query, params);
            return this.output.ok((Representation)new CypherResultRepresentation(result));
        }
        catch (Exception e) {
            return this.output.badRequest(e);
        }
    }
}

