/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.jmx.Primitives;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.server.WrappingNeoServerBootstrapper;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.configuration.ServerConfigurator;
import org.neo4j.server.helpers.FunctionalTestHelper;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RESTDocsGenerator;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.shell.ShellSettings;
import org.neo4j.test.ImpermanentGraphDatabase;
import org.neo4j.test.TestData;
import org.neo4j.test.server.ExclusiveServerTestBase;

public class WrappingNeoServerBootstrapperTest
extends ExclusiveServerTestBase {
    @Rule
    public TestData<RESTDocsGenerator> gen = TestData.producedThrough(RESTDocsGenerator.PRODUCER);
    static InternalAbstractGraphDatabase myDb;

    @BeforeClass
    public static void setup() throws IOException {
        myDb = new ImpermanentGraphDatabase();
    }

    @AfterClass
    public static void teardown() {
        myDb.shutdown();
    }

    private InternalAbstractGraphDatabase getGraphDb() {
        return myDb;
    }

    @Test
    public void usingWrappingNeoServerBootstrapper() {
        InternalAbstractGraphDatabase graphdb = this.getGraphDb();
        WrappingNeoServerBootstrapper srv = new WrappingNeoServerBootstrapper((GraphDatabaseAPI)graphdb);
        srv.start();
        srv.stop();
    }

    @Test
    public void shouldAllowModifyingProperties() {
        GraphDatabaseAPI graphdb = (GraphDatabaseAPI)new GraphDatabaseFactory().newEmbeddedDatabaseBuilder("target/configDb").setConfig((GraphDatabaseSetting)ShellSettings.remote_shell_enabled, "true").newGraphDatabase();
        ServerConfigurator config = new ServerConfigurator(graphdb);
        config.configuration().setProperty("org.neo4j.server.webserver.port", (Object)7575);
        WrappingNeoServerBootstrapper srv = new WrappingNeoServerBootstrapper(graphdb, (Configurator)config);
        srv.start();
        Assert.assertEquals((long)srv.getServer().baseUri().getPort(), (long)7575L);
        String response = ((RESTDocsGenerator)((Object)this.gen.get())).payload("{\"command\" : \"ls\",\"engine\":\"shell\"}").expectedStatus(ClientResponse.Status.OK.getStatusCode()).post("http://127.0.0.1:7575/db/manage/server/console/").entity();
        Assert.assertTrue((boolean)response.contains("neo4j-sh (0)$"));
        srv.stop();
    }

    @Test
    public void shouldAllowShellConsoleWithoutCustomConfig() {
        WrappingNeoServerBootstrapper srv = new WrappingNeoServerBootstrapper((GraphDatabaseAPI)this.getGraphDb());
        srv.start();
        String response = ((RESTDocsGenerator)((Object)this.gen.get())).payload("{\"command\" : \"ls\",\"engine\":\"shell\"}").expectedStatus(ClientResponse.Status.OK.getStatusCode()).post("http://127.0.0.1:7474/db/manage/server/console/").entity();
        Assert.assertTrue((boolean)response.contains("neo4j-sh (0)$"));
        srv.stop();
    }

    @Test
    public void shouldAllowModifyingListenPorts() throws UnknownHostException {
        ServerConfigurator config = new ServerConfigurator((GraphDatabaseAPI)myDb);
        String hostAddress = InetAddress.getLocalHost().getHostAddress();
        config.configuration().setProperty("org.neo4j.server.webserver.address", (Object)hostAddress);
        WrappingNeoServerBootstrapper srv = new WrappingNeoServerBootstrapper((GraphDatabaseAPI)myDb, (Configurator)config);
        srv.start();
        try {
            ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(ClientResponse.Status.OK.getStatusCode()).get("http://127.0.0.1:7474/db/data/");
            Assert.fail();
        }
        catch (ClientHandlerException cee) {
            // empty catch block
        }
        ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(ClientResponse.Status.OK.getStatusCode()).get("http://" + hostAddress + ":7474/db/data/");
        srv.stop();
    }

    @Test
    public void shouldResponseAndBeAbleToModifyDb() {
        WrappingNeoServerBootstrapper srv = new WrappingNeoServerBootstrapper((GraphDatabaseAPI)myDb);
        srv.start();
        long originalNodeNumber = ((Primitives)myDb.getManagementBean(Primitives.class)).getNumberOfNodeIdsInUse();
        FunctionalTestHelper helper = new FunctionalTestHelper(srv.getServer());
        JaxRsResponse response = new RestRequest().get(helper.dataUri());
        Assert.assertEquals((long)200L, (long)response.getStatus());
        String nodeData = "{\"age\":12}";
        response = new RestRequest().post(helper.dataUri() + "node", nodeData);
        Assert.assertEquals((long)201L, (long)response.getStatus());
        long newNodeNumber = ((Primitives)myDb.getManagementBean(Primitives.class)).getNumberOfNodeIdsInUse();
        Assert.assertEquals((long)(originalNodeNumber + 1L), (long)newNodeNumber);
        srv.stop();
        Assert.assertTrue((myDb.getReferenceNode() != null ? 1 : 0) != 0);
    }
}

