/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.configuration;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.info.DiagnosticsExtractor;
import org.neo4j.kernel.info.DiagnosticsPhase;
import org.neo4j.server.configuration.ThirdPartyJaxRsPackage;
import org.neo4j.server.webadmin.rest.SessionFactoryImpl;

public interface Configurator {
    public static final String SECURITY_RULES_KEY = "org.neo4j.server.rest.security_rules";
    public static final String DB_TUNING_PROPERTY_FILE_KEY = "org.neo4j.server.db.tuning.properties";
    public static final String DEFAULT_CONFIG_DIR = File.separator + "etc" + File.separator + "neo";
    public static final String DATABASE_LOCATION_PROPERTY_KEY = "org.neo4j.server.database.location";
    public static final String NEO_SERVER_CONFIG_FILE_KEY = "org.neo4j.server.properties";
    public static final String DB_MODE_KEY = "org.neo4j.server.database.mode";
    public static final String DEFAULT_DATABASE_LOCATION_PROPERTY_KEY = "data/graph.db";
    public static final int DEFAULT_WEBSERVER_PORT = 7474;
    public static final String WEBSERVER_PORT_PROPERTY_KEY = "org.neo4j.server.webserver.port";
    public static final String DEFAULT_WEBSERVER_ADDRESS = "localhost";
    public static final String WEBSERVER_ADDRESS_PROPERTY_KEY = "org.neo4j.server.webserver.address";
    public static final String WEBSERVER_MAX_THREADS_PROPERTY_KEY = "org.neo4j.server.webserver.maxthreads";
    public static final String WEBSERVER_LIMIT_EXECUTION_TIME_PROPERTY_KEY = "org.neo4j.server.webserver.limit.executiontime";
    public static final String REST_API_PATH_PROPERTY_KEY = "org.neo4j.server.webadmin.data.uri";
    public static final String REST_API_PACKAGE = "org.neo4j.server.rest.web";
    public static final String DEFAULT_DATA_API_PATH = "/db/data";
    public static final String DISCOVERY_API_PACKAGE = "org.neo4j.server.rest.discovery";
    public static final String MANAGEMENT_API_PACKAGE = "org.neo4j.server.webadmin.rest";
    public static final String MANAGEMENT_PATH_PROPERTY_KEY = "org.neo4j.server.webadmin.management.uri";
    public static final String DEFAULT_MANAGEMENT_API_PATH = "/db/manage";
    public static final String DEFAULT_WEB_ADMIN_PATH = "/webadmin";
    public static final String RRDB_LOCATION_PROPERTY_KEY = "org.neo4j.server.webadmin.rrdb.location";
    public static final String MANAGEMENT_CONSOLE_ENGINES = "org.neo4j.server.manage.console_engines";
    public static final List<String> DEFAULT_MANAGEMENT_CONSOLE_ENGINES = new ArrayList<String>(){
        private static final long serialVersionUID = 6621747998288594121L;
        {
            this.add(SessionFactoryImpl.ConsoleEngineCreator.SHELL.name().toLowerCase());
            this.add(SessionFactoryImpl.ConsoleEngineCreator.GREMLIN.name().toLowerCase());
        }
    };
    public static final String THIRD_PARTY_PACKAGES_KEY = "org.neo4j.server.thirdparty_jaxrs_classes";
    public static final String WEBSERVER_HTTPS_ENABLED_PROPERTY_KEY = "org.neo4j.server.webserver.https.enabled";
    public static final Boolean DEFAULT_WEBSERVER_HTTPS_ENABLED = false;
    public static final String WEBSERVER_HTTPS_PORT_PROPERTY_KEY = "org.neo4j.server.webserver.https.port";
    public static final int DEFAULT_WEBSERVER_HTTPS_PORT = 7473;
    public static final String WEBSERVER_KEYSTORE_PATH_PROPERTY_KEY = "org.neo4j.server.webserver.https.keystore.location";
    public static final String DEFAULT_WEBSERVER_KEYSTORE_PATH = "neo4j-home/ssl/keystore";
    public static final String WEBSERVER_HTTPS_CERT_PATH_PROPERTY_KEY = "org.neo4j.server.webserver.https.cert.location";
    public static final String DEFAULT_WEBSERVER_HTTPS_CERT_PATH = "neo4j-home/ssl/snakeoil.cert";
    public static final String WEBSERVER_HTTPS_KEY_PATH_PROPERTY_KEY = "org.neo4j.server.webserver.https.key.location";
    public static final String DEFAULT_WEBSERVER_HTTPS_KEY_PATH = "neo4j-home/ssl/snakeoil.key";
    public static final String HTTP_LOGGING = "org.neo4j.server.http.log.enabled";
    public static final String HTTP_LOG_CONFIG_LOCATION = "org.neo4j.server.http.log.config";
    public static final String WADL_ENABLED = "unsupported_wadl_generation_enabled";
    public static final DiagnosticsExtractor<Configurator> DIAGNOSTICS = new DiagnosticsExtractor<Configurator>(){

        public void dumpDiagnostics(Configurator source, DiagnosticsPhase phase, StringLogger log) {
            if (phase.isInitialization() || phase.isExplicitlyRequested()) {
                final Configuration config = source.configuration();
                log.logLongMessage("Server configuration:", (Iterator)new PrefetchingIterator<String>(){
                    final Iterator<?> keys;
                    {
                        this.keys = config.getKeys();
                    }

                    protected String fetchNextOrNull() {
                        while (this.keys.hasNext()) {
                            Object key = this.keys.next();
                            if (!(key instanceof String)) continue;
                            return key + " = " + config.getProperty((String)key);
                        }
                        return null;
                    }
                }, true);
            }
        }

        public String toString() {
            return Configurator.class.getName();
        }
    };

    public Configuration configuration();

    public Map<String, String> getDatabaseTuningProperties();

    public Set<ThirdPartyJaxRsPackage> getThirdpartyJaxRsClasses();
}

